<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityLocation ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityLocation extends AbstractStructArrayBase
{
    /**
     * The ActivityLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityLocation[]
     */
    public $ActivityLocation;
    /**
     * Constructor method for ArrayOfActivityLocation
     * @uses ArrayOfActivityLocation::setActivityLocation()
     * @param ActivityLocation[] $activityLocation
     */
    public function __construct(array $activityLocation = array())
    {
        $this
            ->setActivityLocation($activityLocation);
    }
    /**
     * Get ActivityLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityLocation[]|null
     */
    public function getActivityLocation()
    {
        return isset($this->ActivityLocation) ? $this->ActivityLocation : null;
    }
    /**
     * Set ActivityLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityLocation[] $activityLocation
     * @return ArrayOfActivityLocation
     */
    public function setActivityLocation(array $activityLocation = array())
    {
        foreach ($activityLocation as $arrayOfActivityLocationActivityLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityLocationActivityLocationItem instanceof ActivityLocation) {
                throw new \InvalidArgumentException(sprintf('The ActivityLocation property can only contain items of ActivityLocation, "%s" given', is_object($arrayOfActivityLocationActivityLocationItem) ? get_class($arrayOfActivityLocationActivityLocationItem) : gettype($arrayOfActivityLocationActivityLocationItem)), __LINE__);
            }
        }
        if (is_null($activityLocation) || (is_array($activityLocation) && empty($activityLocation))) {
            unset($this->ActivityLocation);
        } else {
            $this->ActivityLocation = $activityLocation;
        }
        return $this;
    }
    /**
     * Add item to ActivityLocation value
     * @throws \InvalidArgumentException
     * @param ActivityLocation $item
     * @return ArrayOfActivityLocation
     */
    public function addToActivityLocation(ActivityLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityLocation) {
            throw new \InvalidArgumentException(sprintf('The ActivityLocation property can only contain items of ActivityLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityLocation
     */
    public function getAttributeName()
    {
        return 'ActivityLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
