<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityAttempt ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityAttempt extends AbstractStructArrayBase
{
    /**
     * The ActivityAttempt
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityAttempt[]
     */
    public $ActivityAttempt;
    /**
     * Constructor method for ArrayOfActivityAttempt
     * @uses ArrayOfActivityAttempt::setActivityAttempt()
     * @param ActivityAttempt[] $activityAttempt
     */
    public function __construct(array $activityAttempt = array())
    {
        $this
            ->setActivityAttempt($activityAttempt);
    }
    /**
     * Get ActivityAttempt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityAttempt[]|null
     */
    public function getActivityAttempt()
    {
        return isset($this->ActivityAttempt) ? $this->ActivityAttempt : null;
    }
    /**
     * Set ActivityAttempt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityAttempt[] $activityAttempt
     * @return ArrayOfActivityAttempt
     */
    public function setActivityAttempt(array $activityAttempt = array())
    {
        foreach ($activityAttempt as $arrayOfActivityAttemptActivityAttemptItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityAttemptActivityAttemptItem instanceof ActivityAttempt) {
                throw new \InvalidArgumentException(sprintf('The ActivityAttempt property can only contain items of ActivityAttempt, "%s" given', is_object($arrayOfActivityAttemptActivityAttemptItem) ? get_class($arrayOfActivityAttemptActivityAttemptItem) : gettype($arrayOfActivityAttemptActivityAttemptItem)), __LINE__);
            }
        }
        if (is_null($activityAttempt) || (is_array($activityAttempt) && empty($activityAttempt))) {
            unset($this->ActivityAttempt);
        } else {
            $this->ActivityAttempt = $activityAttempt;
        }
        return $this;
    }
    /**
     * Add item to ActivityAttempt value
     * @throws \InvalidArgumentException
     * @param ActivityAttempt $item
     * @return ArrayOfActivityAttempt
     */
    public function addToActivityAttempt(ActivityAttempt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityAttempt) {
            throw new \InvalidArgumentException(sprintf('The ActivityAttempt property can only contain items of ActivityAttempt, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityAttempt[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityAttempt|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityAttempt|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityAttempt|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityAttempt|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityAttempt|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityAttempt
     */
    public function getAttributeName()
    {
        return 'ActivityAttempt';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityAttempt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
