<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the UserSecurityContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param UserSecurityContext $userSecurityContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSecurityContext(UserSecurityContext $userSecurityContext, $nameSpace = 'http://www.sumtotalsystems.com/sumtotal7/sumtotalws/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSecurityContext', $userSecurityContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddUpdateRequiredSkill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateRequiredSkill $parameters
     * @return AddUpdateRequiredSkillResponse|bool
     */
    public function AddUpdateRequiredSkill(AddUpdateRequiredSkill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateRequiredSkill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUpdateAcquiredSkill
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateAcquiredSkill $parameters
     * @return AddUpdateAcquiredSkillResponse|bool
     */
    public function AddUpdateAcquiredSkill(AddUpdateAcquiredSkill $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateAcquiredSkill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUpdateRequiredCompetency
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateRequiredCompetency $parameters
     * @return AddUpdateRequiredCompetencyResponse|bool
     */
    public function AddUpdateRequiredCompetency(AddUpdateRequiredCompetency $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateRequiredCompetency($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUpdateRequiredActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateRequiredActivity $parameters
     * @return AddUpdateRequiredActivityResponse|bool
     */
    public function AddUpdateRequiredActivity(AddUpdateRequiredActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateRequiredActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AddUpdateRequiredActivityWithDueDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateRequiredActivityWithDueDate $parameters
     * @return AddUpdateRequiredActivityWithDueDateResponse|bool
     */
    public function AddUpdateRequiredActivityWithDueDate(AddUpdateRequiredActivityWithDueDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateRequiredActivityWithDueDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AddUpdateRequiredActivityWithStartDateAndDueDate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param AddUpdateRequiredActivityWithStartDateAndDueDate $parameters
     * @return AddUpdateRequiredActivityWithStartDateAndDueDateResponse|bool
     */
    public function AddUpdateRequiredActivityWithStartDateAndDueDate(AddUpdateRequiredActivityWithStartDateAndDueDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUpdateRequiredActivityWithStartDateAndDueDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return AddUpdateAcquiredSkillResponse|AddUpdateRequiredActivityResponse|AddUpdateRequiredActivityWithDueDateResponse|AddUpdateRequiredActivityWithStartDateAndDueDateResponse|AddUpdateRequiredCompetencyResponse|AddUpdateRequiredSkillResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
