<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivitySystemMetadataPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivitySystemMetadataPropertyBase extends Entity
{
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $ExpiryDate;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The MediaTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MediaTypeId;
    /**
     * The MediaType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var MediaType
     */
    public $MediaType;
    /**
     * The ContentTypeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentTypeId;
    /**
     * The ContentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ContentType
     */
    public $ContentType;
    /**
     * The LEMtdId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LEMtdId;
    /**
     * The LEMtd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LEMtd
     */
    public $LEMtd;
    /**
     * Constructor method for ActivitySystemMetadataPropertyBase
     * @uses ActivitySystemMetadataPropertyBase::setExpiryDate()
     * @uses ActivitySystemMetadataPropertyBase::setId()
     * @uses ActivitySystemMetadataPropertyBase::setMediaTypeId()
     * @uses ActivitySystemMetadataPropertyBase::setMediaType()
     * @uses ActivitySystemMetadataPropertyBase::setContentTypeId()
     * @uses ActivitySystemMetadataPropertyBase::setContentType()
     * @uses ActivitySystemMetadataPropertyBase::setLEMtdId()
     * @uses ActivitySystemMetadataPropertyBase::setLEMtd()
     * @param NullableDateTime $expiryDate
     * @param string $id
     * @param string $mediaTypeId
     * @param MediaType $mediaType
     * @param string $contentTypeId
     * @param ContentType $contentType
     * @param string $lEMtdId
     * @param LEMtd $lEMtd
     */
    public function __construct(NullableDateTime $expiryDate = null, $id = null, $mediaTypeId = null, MediaType $mediaType = null, $contentTypeId = null, ContentType $contentType = null, $lEMtdId = null, LEMtd $lEMtd = null)
    {
        $this
            ->setExpiryDate($expiryDate)
            ->setId($id)
            ->setMediaTypeId($mediaTypeId)
            ->setMediaType($mediaType)
            ->setContentTypeId($contentTypeId)
            ->setContentType($contentType)
            ->setLEMtdId($lEMtdId)
            ->setLEMtd($lEMtd);
    }
    /**
     * Get ExpiryDate value
     * @return NullableDateTime
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param NullableDateTime $expiryDate
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setExpiryDate(NullableDateTime $expiryDate = null)
    {
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MediaTypeId value
     * @return string|null
     */
    public function getMediaTypeId()
    {
        return $this->MediaTypeId;
    }
    /**
     * Set MediaTypeId value
     * @param string $mediaTypeId
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setMediaTypeId($mediaTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mediaTypeId) && !is_string($mediaTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mediaTypeId)), __LINE__);
        }
        $this->MediaTypeId = $mediaTypeId;
        return $this;
    }
    /**
     * Get MediaType value
     * @return MediaType|null
     */
    public function getMediaType()
    {
        return $this->MediaType;
    }
    /**
     * Set MediaType value
     * @param MediaType $mediaType
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setMediaType(MediaType $mediaType = null)
    {
        $this->MediaType = $mediaType;
        return $this;
    }
    /**
     * Get ContentTypeId value
     * @return string|null
     */
    public function getContentTypeId()
    {
        return $this->ContentTypeId;
    }
    /**
     * Set ContentTypeId value
     * @param string $contentTypeId
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setContentTypeId($contentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($contentTypeId) && !is_string($contentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contentTypeId)), __LINE__);
        }
        $this->ContentTypeId = $contentTypeId;
        return $this;
    }
    /**
     * Get ContentType value
     * @return ContentType|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param ContentType $contentType
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setContentType(ContentType $contentType = null)
    {
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get LEMtdId value
     * @return string|null
     */
    public function getLEMtdId()
    {
        return $this->LEMtdId;
    }
    /**
     * Set LEMtdId value
     * @param string $lEMtdId
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setLEMtdId($lEMtdId = null)
    {
        // validation for constraint: string
        if (!is_null($lEMtdId) && !is_string($lEMtdId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lEMtdId)), __LINE__);
        }
        $this->LEMtdId = $lEMtdId;
        return $this;
    }
    /**
     * Get LEMtd value
     * @return LEMtd|null
     */
    public function getLEMtd()
    {
        return $this->LEMtd;
    }
    /**
     * Set LEMtd value
     * @param LEMtd $lEMtd
     * @return ActivitySystemMetadataPropertyBase
     */
    public function setLEMtd(LEMtd $lEMtd = null)
    {
        $this->LEMtd = $lEMtd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivitySystemMetadataPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
