<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityRegistrationPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityRegistrationPropertyBase extends Entity
{
    /**
     * The RegistrationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RegistrationStatus;
    /**
     * The ReminderNoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $ReminderNoteDate;
    /**
     * The ConfirmationNoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $ConfirmationNoteDate;
    /**
     * The CancelledNoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $CancelledNoteDate;
    /**
     * The CertificationNoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $CertificationNoteDate;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $User;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The AllocationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AllocationId;
    /**
     * The Allocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityAllocation
     */
    public $Allocation;
    /**
     * Constructor method for ActivityRegistrationPropertyBase
     * @uses ActivityRegistrationPropertyBase::setRegistrationStatus()
     * @uses ActivityRegistrationPropertyBase::setReminderNoteDate()
     * @uses ActivityRegistrationPropertyBase::setConfirmationNoteDate()
     * @uses ActivityRegistrationPropertyBase::setCancelledNoteDate()
     * @uses ActivityRegistrationPropertyBase::setCertificationNoteDate()
     * @uses ActivityRegistrationPropertyBase::setId()
     * @uses ActivityRegistrationPropertyBase::setUserId()
     * @uses ActivityRegistrationPropertyBase::setUser()
     * @uses ActivityRegistrationPropertyBase::setActivityId()
     * @uses ActivityRegistrationPropertyBase::setActivity()
     * @uses ActivityRegistrationPropertyBase::setAllocationId()
     * @uses ActivityRegistrationPropertyBase::setAllocation()
     * @param string $registrationStatus
     * @param NullableDateTime $reminderNoteDate
     * @param NullableDateTime $confirmationNoteDate
     * @param NullableDateTime $cancelledNoteDate
     * @param NullableDateTime $certificationNoteDate
     * @param string $id
     * @param string $userId
     * @param User $user
     * @param string $activityId
     * @param Activity $activity
     * @param string $allocationId
     * @param ActivityAllocation $allocation
     */
    public function __construct($registrationStatus = null, NullableDateTime $reminderNoteDate = null, NullableDateTime $confirmationNoteDate = null, NullableDateTime $cancelledNoteDate = null, NullableDateTime $certificationNoteDate = null, $id = null, $userId = null, User $user = null, $activityId = null, Activity $activity = null, $allocationId = null, ActivityAllocation $allocation = null)
    {
        $this
            ->setRegistrationStatus($registrationStatus)
            ->setReminderNoteDate($reminderNoteDate)
            ->setConfirmationNoteDate($confirmationNoteDate)
            ->setCancelledNoteDate($cancelledNoteDate)
            ->setCertificationNoteDate($certificationNoteDate)
            ->setId($id)
            ->setUserId($userId)
            ->setUser($user)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setAllocationId($allocationId)
            ->setAllocation($allocation);
    }
    /**
     * Get RegistrationStatus value
     * @return string
     */
    public function getRegistrationStatus()
    {
        return $this->RegistrationStatus;
    }
    /**
     * Set RegistrationStatus value
     * @uses RegistrationStatus::valueIsValid()
     * @uses RegistrationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $registrationStatus
     * @return ActivityRegistrationPropertyBase
     */
    public function setRegistrationStatus($registrationStatus = null)
    {
        // validation for constraint: enumeration
        if (!RegistrationStatus::valueIsValid($registrationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $registrationStatus, implode(', ', RegistrationStatus::getValidValues())), __LINE__);
        }
        $this->RegistrationStatus = $registrationStatus;
        return $this;
    }
    /**
     * Get ReminderNoteDate value
     * @return NullableDateTime
     */
    public function getReminderNoteDate()
    {
        return $this->ReminderNoteDate;
    }
    /**
     * Set ReminderNoteDate value
     * @param NullableDateTime $reminderNoteDate
     * @return ActivityRegistrationPropertyBase
     */
    public function setReminderNoteDate(NullableDateTime $reminderNoteDate = null)
    {
        $this->ReminderNoteDate = $reminderNoteDate;
        return $this;
    }
    /**
     * Get ConfirmationNoteDate value
     * @return NullableDateTime
     */
    public function getConfirmationNoteDate()
    {
        return $this->ConfirmationNoteDate;
    }
    /**
     * Set ConfirmationNoteDate value
     * @param NullableDateTime $confirmationNoteDate
     * @return ActivityRegistrationPropertyBase
     */
    public function setConfirmationNoteDate(NullableDateTime $confirmationNoteDate = null)
    {
        $this->ConfirmationNoteDate = $confirmationNoteDate;
        return $this;
    }
    /**
     * Get CancelledNoteDate value
     * @return NullableDateTime
     */
    public function getCancelledNoteDate()
    {
        return $this->CancelledNoteDate;
    }
    /**
     * Set CancelledNoteDate value
     * @param NullableDateTime $cancelledNoteDate
     * @return ActivityRegistrationPropertyBase
     */
    public function setCancelledNoteDate(NullableDateTime $cancelledNoteDate = null)
    {
        $this->CancelledNoteDate = $cancelledNoteDate;
        return $this;
    }
    /**
     * Get CertificationNoteDate value
     * @return NullableDateTime
     */
    public function getCertificationNoteDate()
    {
        return $this->CertificationNoteDate;
    }
    /**
     * Set CertificationNoteDate value
     * @param NullableDateTime $certificationNoteDate
     * @return ActivityRegistrationPropertyBase
     */
    public function setCertificationNoteDate(NullableDateTime $certificationNoteDate = null)
    {
        $this->CertificationNoteDate = $certificationNoteDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityRegistrationPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return ActivityRegistrationPropertyBase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get User value
     * @return User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param User $user
     * @return ActivityRegistrationPropertyBase
     */
    public function setUser(User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityRegistrationPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityRegistrationPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get AllocationId value
     * @return string|null
     */
    public function getAllocationId()
    {
        return $this->AllocationId;
    }
    /**
     * Set AllocationId value
     * @param string $allocationId
     * @return ActivityRegistrationPropertyBase
     */
    public function setAllocationId($allocationId = null)
    {
        // validation for constraint: string
        if (!is_null($allocationId) && !is_string($allocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allocationId)), __LINE__);
        }
        $this->AllocationId = $allocationId;
        return $this;
    }
    /**
     * Get Allocation value
     * @return ActivityAllocation|null
     */
    public function getAllocation()
    {
        return $this->Allocation;
    }
    /**
     * Set Allocation value
     * @param ActivityAllocation $allocation
     * @return ActivityRegistrationPropertyBase
     */
    public function setAllocation(ActivityAllocation $allocation = null)
    {
        $this->Allocation = $allocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityRegistrationPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
