<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityMetadataPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityMetadataPropertyBase extends Entity
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Keys
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Keys;
    /**
     * The Values
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Values;
    /**
     * Constructor method for ActivityMetadataPropertyBase
     * @uses ActivityMetadataPropertyBase::setId()
     * @uses ActivityMetadataPropertyBase::setKeys()
     * @uses ActivityMetadataPropertyBase::setValues()
     * @param string $id
     * @param string[] $keys
     * @param string[] $values
     */
    public function __construct($id = null, array $keys = array(), array $values = array())
    {
        $this
            ->setId($id)
            ->setKeys($keys)
            ->setValues($values);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityMetadataPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Keys value
     * @return string[]|null
     */
    public function getKeys()
    {
        return $this->Keys;
    }
    /**
     * Set Keys value
     * @throws \InvalidArgumentException
     * @param string[] $keys
     * @return ActivityMetadataPropertyBase
     */
    public function setKeys(array $keys = array())
    {
        foreach ($keys as $activityMetadataPropertyBaseKeysItem) {
            // validation for constraint: itemType
            if (!is_string($activityMetadataPropertyBaseKeysItem)) {
                throw new \InvalidArgumentException(sprintf('The Keys property can only contain items of string, "%s" given', is_object($activityMetadataPropertyBaseKeysItem) ? get_class($activityMetadataPropertyBaseKeysItem) : gettype($activityMetadataPropertyBaseKeysItem)), __LINE__);
            }
        }
        $this->Keys = $keys;
        return $this;
    }
    /**
     * Add item to Keys value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return ActivityMetadataPropertyBase
     */
    public function addToKeys($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Keys property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Keys[] = $item;
        return $this;
    }
    /**
     * Get Values value
     * @return string[]|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @throws \InvalidArgumentException
     * @param string[] $values
     * @return ActivityMetadataPropertyBase
     */
    public function setValues(array $values = array())
    {
        foreach ($values as $activityMetadataPropertyBaseValuesItem) {
            // validation for constraint: itemType
            if (!is_string($activityMetadataPropertyBaseValuesItem)) {
                throw new \InvalidArgumentException(sprintf('The Values property can only contain items of string, "%s" given', is_object($activityMetadataPropertyBaseValuesItem) ? get_class($activityMetadataPropertyBaseValuesItem) : gettype($activityMetadataPropertyBaseValuesItem)), __LINE__);
            }
        }
        $this->Values = $values;
        return $this;
    }
    /**
     * Add item to Values value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return ActivityMetadataPropertyBase
     */
    public function addToValues($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Values property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Values[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityMetadataPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
