<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInstructorPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityInstructorPropertyBase extends Entity
{
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsPrimary;
    /**
     * The IsResponsible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsResponsible;
    /**
     * The IsQualified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsQualified;
    /**
     * The IsConfirmed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsConfirmed;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The InstructorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstructorId;
    /**
     * The Instructor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Instructor;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * Constructor method for ActivityInstructorPropertyBase
     * @uses ActivityInstructorPropertyBase::setIsPrimary()
     * @uses ActivityInstructorPropertyBase::setIsResponsible()
     * @uses ActivityInstructorPropertyBase::setIsQualified()
     * @uses ActivityInstructorPropertyBase::setIsConfirmed()
     * @uses ActivityInstructorPropertyBase::setId()
     * @uses ActivityInstructorPropertyBase::setActivityId()
     * @uses ActivityInstructorPropertyBase::setActivity()
     * @uses ActivityInstructorPropertyBase::setInstructorId()
     * @uses ActivityInstructorPropertyBase::setInstructor()
     * @uses ActivityInstructorPropertyBase::setNotes()
     * @param int $isPrimary
     * @param int $isResponsible
     * @param int $isQualified
     * @param int $isConfirmed
     * @param string $id
     * @param string $activityId
     * @param Activity $activity
     * @param string $instructorId
     * @param User $instructor
     * @param string $notes
     */
    public function __construct($isPrimary = null, $isResponsible = null, $isQualified = null, $isConfirmed = null, $id = null, $activityId = null, Activity $activity = null, $instructorId = null, User $instructor = null, $notes = null)
    {
        $this
            ->setIsPrimary($isPrimary)
            ->setIsResponsible($isResponsible)
            ->setIsQualified($isQualified)
            ->setIsConfirmed($isConfirmed)
            ->setId($id)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setInstructorId($instructorId)
            ->setInstructor($instructor)
            ->setNotes($notes);
    }
    /**
     * Get IsPrimary value
     * @return int
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param int $isPrimary
     * @return ActivityInstructorPropertyBase
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: int
        if (!is_null($isPrimary) && !is_numeric($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get IsResponsible value
     * @return int
     */
    public function getIsResponsible()
    {
        return $this->IsResponsible;
    }
    /**
     * Set IsResponsible value
     * @param int $isResponsible
     * @return ActivityInstructorPropertyBase
     */
    public function setIsResponsible($isResponsible = null)
    {
        // validation for constraint: int
        if (!is_null($isResponsible) && !is_numeric($isResponsible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isResponsible)), __LINE__);
        }
        $this->IsResponsible = $isResponsible;
        return $this;
    }
    /**
     * Get IsQualified value
     * @return int
     */
    public function getIsQualified()
    {
        return $this->IsQualified;
    }
    /**
     * Set IsQualified value
     * @param int $isQualified
     * @return ActivityInstructorPropertyBase
     */
    public function setIsQualified($isQualified = null)
    {
        // validation for constraint: int
        if (!is_null($isQualified) && !is_numeric($isQualified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isQualified)), __LINE__);
        }
        $this->IsQualified = $isQualified;
        return $this;
    }
    /**
     * Get IsConfirmed value
     * @return int
     */
    public function getIsConfirmed()
    {
        return $this->IsConfirmed;
    }
    /**
     * Set IsConfirmed value
     * @param int $isConfirmed
     * @return ActivityInstructorPropertyBase
     */
    public function setIsConfirmed($isConfirmed = null)
    {
        // validation for constraint: int
        if (!is_null($isConfirmed) && !is_numeric($isConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isConfirmed)), __LINE__);
        }
        $this->IsConfirmed = $isConfirmed;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityInstructorPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityInstructorPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityInstructorPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get InstructorId value
     * @return string|null
     */
    public function getInstructorId()
    {
        return $this->InstructorId;
    }
    /**
     * Set InstructorId value
     * @param string $instructorId
     * @return ActivityInstructorPropertyBase
     */
    public function setInstructorId($instructorId = null)
    {
        // validation for constraint: string
        if (!is_null($instructorId) && !is_string($instructorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instructorId)), __LINE__);
        }
        $this->InstructorId = $instructorId;
        return $this;
    }
    /**
     * Get Instructor value
     * @return User|null
     */
    public function getInstructor()
    {
        return $this->Instructor;
    }
    /**
     * Set Instructor value
     * @param User $instructor
     * @return ActivityInstructorPropertyBase
     */
    public function setInstructor(User $instructor = null)
    {
        $this->Instructor = $instructor;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return ActivityInstructorPropertyBase
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityInstructorPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
