<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityCatalogsPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityCatalogsPropertyBase extends Entity
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The CatalogId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CatalogId;
    /**
     * The Catalog
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Catalog
     */
    public $Catalog;
    /**
     * Constructor method for ActivityCatalogsPropertyBase
     * @uses ActivityCatalogsPropertyBase::setId()
     * @uses ActivityCatalogsPropertyBase::setActivityId()
     * @uses ActivityCatalogsPropertyBase::setActivity()
     * @uses ActivityCatalogsPropertyBase::setCatalogId()
     * @uses ActivityCatalogsPropertyBase::setCatalog()
     * @param string $id
     * @param string $activityId
     * @param Activity $activity
     * @param string $catalogId
     * @param Catalog $catalog
     */
    public function __construct($id = null, $activityId = null, Activity $activity = null, $catalogId = null, Catalog $catalog = null)
    {
        $this
            ->setId($id)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setCatalogId($catalogId)
            ->setCatalog($catalog);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityCatalogsPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityCatalogsPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityCatalogsPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get CatalogId value
     * @return string|null
     */
    public function getCatalogId()
    {
        return $this->CatalogId;
    }
    /**
     * Set CatalogId value
     * @param string $catalogId
     * @return ActivityCatalogsPropertyBase
     */
    public function setCatalogId($catalogId = null)
    {
        // validation for constraint: string
        if (!is_null($catalogId) && !is_string($catalogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($catalogId)), __LINE__);
        }
        $this->CatalogId = $catalogId;
        return $this;
    }
    /**
     * Get Catalog value
     * @return Catalog|null
     */
    public function getCatalog()
    {
        return $this->Catalog;
    }
    /**
     * Set Catalog value
     * @param Catalog $catalog
     * @return ActivityCatalogsPropertyBase
     */
    public function setCatalog(Catalog $catalog = null)
    {
        $this->Catalog = $catalog;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityCatalogsPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
