<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAttemptPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityAttemptPropertyBase extends Entity
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $EndDate;
    /**
     * The IsWaived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsWaived;
    /**
     * The IsComplete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsComplete;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Success;
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $Score;
    /**
     * The Grade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $Grade;
    /**
     * The ElapsedSeconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $ElapsedSeconds;
    /**
     * The MergedSkills
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MergedSkills;
    /**
     * The HasAttended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $HasAttended;
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $Source;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $User;
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityId;
    /**
     * The Activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $Activity;
    /**
     * The RegistrationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistrationId;
    /**
     * The Registration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ActivityRegistration
     */
    public $Registration;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * Constructor method for ActivityAttemptPropertyBase
     * @uses ActivityAttemptPropertyBase::setStartDate()
     * @uses ActivityAttemptPropertyBase::setEndDate()
     * @uses ActivityAttemptPropertyBase::setIsWaived()
     * @uses ActivityAttemptPropertyBase::setIsComplete()
     * @uses ActivityAttemptPropertyBase::setSuccess()
     * @uses ActivityAttemptPropertyBase::setScore()
     * @uses ActivityAttemptPropertyBase::setGrade()
     * @uses ActivityAttemptPropertyBase::setElapsedSeconds()
     * @uses ActivityAttemptPropertyBase::setMergedSkills()
     * @uses ActivityAttemptPropertyBase::setHasAttended()
     * @uses ActivityAttemptPropertyBase::setSource()
     * @uses ActivityAttemptPropertyBase::setId()
     * @uses ActivityAttemptPropertyBase::setUserId()
     * @uses ActivityAttemptPropertyBase::setUser()
     * @uses ActivityAttemptPropertyBase::setActivityId()
     * @uses ActivityAttemptPropertyBase::setActivity()
     * @uses ActivityAttemptPropertyBase::setRegistrationId()
     * @uses ActivityAttemptPropertyBase::setRegistration()
     * @uses ActivityAttemptPropertyBase::setNote()
     * @param NullableDateTime $startDate
     * @param NullableDateTime $endDate
     * @param int $isWaived
     * @param string $isComplete
     * @param string $success
     * @param NullableDecimal $score
     * @param NullableInt32 $grade
     * @param NullableDouble $elapsedSeconds
     * @param NullableInt32 $mergedSkills
     * @param NullableInt32 $hasAttended
     * @param NullableInt32 $source
     * @param string $id
     * @param string $userId
     * @param User $user
     * @param string $activityId
     * @param Activity $activity
     * @param string $registrationId
     * @param ActivityRegistration $registration
     * @param string $note
     */
    public function __construct(NullableDateTime $startDate = null, NullableDateTime $endDate = null, $isWaived = null, $isComplete = null, $success = null, NullableDecimal $score = null, NullableInt32 $grade = null, NullableDouble $elapsedSeconds = null, NullableInt32 $mergedSkills = null, NullableInt32 $hasAttended = null, NullableInt32 $source = null, $id = null, $userId = null, User $user = null, $activityId = null, Activity $activity = null, $registrationId = null, ActivityRegistration $registration = null, $note = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setIsWaived($isWaived)
            ->setIsComplete($isComplete)
            ->setSuccess($success)
            ->setScore($score)
            ->setGrade($grade)
            ->setElapsedSeconds($elapsedSeconds)
            ->setMergedSkills($mergedSkills)
            ->setHasAttended($hasAttended)
            ->setSource($source)
            ->setId($id)
            ->setUserId($userId)
            ->setUser($user)
            ->setActivityId($activityId)
            ->setActivity($activity)
            ->setRegistrationId($registrationId)
            ->setRegistration($registration)
            ->setNote($note);
    }
    /**
     * Get StartDate value
     * @return NullableDateTime
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param NullableDateTime $startDate
     * @return ActivityAttemptPropertyBase
     */
    public function setStartDate(NullableDateTime $startDate = null)
    {
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return NullableDateTime
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param NullableDateTime $endDate
     * @return ActivityAttemptPropertyBase
     */
    public function setEndDate(NullableDateTime $endDate = null)
    {
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get IsWaived value
     * @return int
     */
    public function getIsWaived()
    {
        return $this->IsWaived;
    }
    /**
     * Set IsWaived value
     * @param int $isWaived
     * @return ActivityAttemptPropertyBase
     */
    public function setIsWaived($isWaived = null)
    {
        // validation for constraint: int
        if (!is_null($isWaived) && !is_numeric($isWaived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isWaived)), __LINE__);
        }
        $this->IsWaived = $isWaived;
        return $this;
    }
    /**
     * Get IsComplete value
     * @return string
     */
    public function getIsComplete()
    {
        return $this->IsComplete;
    }
    /**
     * Set IsComplete value
     * @uses CompletionStatus::valueIsValid()
     * @uses CompletionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isComplete
     * @return ActivityAttemptPropertyBase
     */
    public function setIsComplete($isComplete = null)
    {
        // validation for constraint: enumeration
        if (!CompletionStatus::valueIsValid($isComplete)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $isComplete, implode(', ', CompletionStatus::getValidValues())), __LINE__);
        }
        $this->IsComplete = $isComplete;
        return $this;
    }
    /**
     * Get Success value
     * @return string
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @uses SuccessStatus::valueIsValid()
     * @uses SuccessStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $success
     * @return ActivityAttemptPropertyBase
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: enumeration
        if (!SuccessStatus::valueIsValid($success)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $success, implode(', ', SuccessStatus::getValidValues())), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Score value
     * @return NullableDecimal
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param NullableDecimal $score
     * @return ActivityAttemptPropertyBase
     */
    public function setScore(NullableDecimal $score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Grade value
     * @return NullableInt32
     */
    public function getGrade()
    {
        return $this->Grade;
    }
    /**
     * Set Grade value
     * @param NullableInt32 $grade
     * @return ActivityAttemptPropertyBase
     */
    public function setGrade(NullableInt32 $grade = null)
    {
        $this->Grade = $grade;
        return $this;
    }
    /**
     * Get ElapsedSeconds value
     * @return NullableDouble
     */
    public function getElapsedSeconds()
    {
        return $this->ElapsedSeconds;
    }
    /**
     * Set ElapsedSeconds value
     * @param NullableDouble $elapsedSeconds
     * @return ActivityAttemptPropertyBase
     */
    public function setElapsedSeconds(NullableDouble $elapsedSeconds = null)
    {
        $this->ElapsedSeconds = $elapsedSeconds;
        return $this;
    }
    /**
     * Get MergedSkills value
     * @return NullableInt32
     */
    public function getMergedSkills()
    {
        return $this->MergedSkills;
    }
    /**
     * Set MergedSkills value
     * @param NullableInt32 $mergedSkills
     * @return ActivityAttemptPropertyBase
     */
    public function setMergedSkills(NullableInt32 $mergedSkills = null)
    {
        $this->MergedSkills = $mergedSkills;
        return $this;
    }
    /**
     * Get HasAttended value
     * @return NullableInt32
     */
    public function getHasAttended()
    {
        return $this->HasAttended;
    }
    /**
     * Set HasAttended value
     * @param NullableInt32 $hasAttended
     * @return ActivityAttemptPropertyBase
     */
    public function setHasAttended(NullableInt32 $hasAttended = null)
    {
        $this->HasAttended = $hasAttended;
        return $this;
    }
    /**
     * Get Source value
     * @return NullableInt32
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param NullableInt32 $source
     * @return ActivityAttemptPropertyBase
     */
    public function setSource(NullableInt32 $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityAttemptPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return ActivityAttemptPropertyBase
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get User value
     * @return User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param User $user
     * @return ActivityAttemptPropertyBase
     */
    public function setUser(User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get ActivityId value
     * @return string|null
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param string $activityId
     * @return ActivityAttemptPropertyBase
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get Activity value
     * @return Activity|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param Activity $activity
     * @return ActivityAttemptPropertyBase
     */
    public function setActivity(Activity $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get RegistrationId value
     * @return string|null
     */
    public function getRegistrationId()
    {
        return $this->RegistrationId;
    }
    /**
     * Set RegistrationId value
     * @param string $registrationId
     * @return ActivityAttemptPropertyBase
     */
    public function setRegistrationId($registrationId = null)
    {
        // validation for constraint: string
        if (!is_null($registrationId) && !is_string($registrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationId)), __LINE__);
        }
        $this->RegistrationId = $registrationId;
        return $this;
    }
    /**
     * Get Registration value
     * @return ActivityRegistration|null
     */
    public function getRegistration()
    {
        return $this->Registration;
    }
    /**
     * Set Registration value
     * @param ActivityRegistration $registration
     * @return ActivityAttemptPropertyBase
     */
    public function setRegistration(ActivityRegistration $registration = null)
    {
        $this->Registration = $registration;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return ActivityAttemptPropertyBase
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityAttemptPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
