<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAssignmentStatus StructType
 * @subpackage Structs
 */
class UserAssignmentStatus extends AbstractStructBase
{
    /**
     * The ActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActivityId;
    /**
     * The AssignmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AssignmentType;
    /**
     * The CompletionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CompletionStatus;
    /**
     * The IsCertificationExpired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCertificationExpired;
    /**
     * The ExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $ExpirationDate;
    /**
     * The ActivityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityName;
    /**
     * The ActivityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ActivityCode;
    /**
     * Constructor method for UserAssignmentStatus
     * @uses UserAssignmentStatus::setActivityId()
     * @uses UserAssignmentStatus::setAssignmentType()
     * @uses UserAssignmentStatus::setCompletionStatus()
     * @uses UserAssignmentStatus::setIsCertificationExpired()
     * @uses UserAssignmentStatus::setExpirationDate()
     * @uses UserAssignmentStatus::setActivityName()
     * @uses UserAssignmentStatus::setActivityCode()
     * @param int $activityId
     * @param string $assignmentType
     * @param string $completionStatus
     * @param bool $isCertificationExpired
     * @param NullableDateTime $expirationDate
     * @param string $activityName
     * @param string $activityCode
     */
    public function __construct($activityId = null, $assignmentType = null, $completionStatus = null, $isCertificationExpired = null, NullableDateTime $expirationDate = null, $activityName = null, $activityCode = null)
    {
        $this
            ->setActivityId($activityId)
            ->setAssignmentType($assignmentType)
            ->setCompletionStatus($completionStatus)
            ->setIsCertificationExpired($isCertificationExpired)
            ->setExpirationDate($expirationDate)
            ->setActivityName($activityName)
            ->setActivityCode($activityCode);
    }
    /**
     * Get ActivityId value
     * @return int
     */
    public function getActivityId()
    {
        return $this->ActivityId;
    }
    /**
     * Set ActivityId value
     * @param int $activityId
     * @return UserAssignmentStatus
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: int
        if (!is_null($activityId) && !is_numeric($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->ActivityId = $activityId;
        return $this;
    }
    /**
     * Get AssignmentType value
     * @return string
     */
    public function getAssignmentType()
    {
        return $this->AssignmentType;
    }
    /**
     * Set AssignmentType value
     * @uses AssignmentType::valueIsValid()
     * @uses AssignmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentType
     * @return UserAssignmentStatus
     */
    public function setAssignmentType($assignmentType = null)
    {
        // validation for constraint: enumeration
        if (!AssignmentType::valueIsValid($assignmentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $assignmentType, implode(', ', AssignmentType::getValidValues())), __LINE__);
        }
        $this->AssignmentType = $assignmentType;
        return $this;
    }
    /**
     * Get CompletionStatus value
     * @return string
     */
    public function getCompletionStatus()
    {
        return $this->CompletionStatus;
    }
    /**
     * Set CompletionStatus value
     * @uses AssignmentCompletionStatus::valueIsValid()
     * @uses AssignmentCompletionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $completionStatus
     * @return UserAssignmentStatus
     */
    public function setCompletionStatus($completionStatus = null)
    {
        // validation for constraint: enumeration
        if (!AssignmentCompletionStatus::valueIsValid($completionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $completionStatus, implode(', ', AssignmentCompletionStatus::getValidValues())), __LINE__);
        }
        $this->CompletionStatus = $completionStatus;
        return $this;
    }
    /**
     * Get IsCertificationExpired value
     * @return bool
     */
    public function getIsCertificationExpired()
    {
        return $this->IsCertificationExpired;
    }
    /**
     * Set IsCertificationExpired value
     * @param bool $isCertificationExpired
     * @return UserAssignmentStatus
     */
    public function setIsCertificationExpired($isCertificationExpired = null)
    {
        $this->IsCertificationExpired = $isCertificationExpired;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return NullableDateTime
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param NullableDateTime $expirationDate
     * @return UserAssignmentStatus
     */
    public function setExpirationDate(NullableDateTime $expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get ActivityName value
     * @return string|null
     */
    public function getActivityName()
    {
        return $this->ActivityName;
    }
    /**
     * Set ActivityName value
     * @param string $activityName
     * @return UserAssignmentStatus
     */
    public function setActivityName($activityName = null)
    {
        // validation for constraint: string
        if (!is_null($activityName) && !is_string($activityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityName)), __LINE__);
        }
        $this->ActivityName = $activityName;
        return $this;
    }
    /**
     * Get ActivityCode value
     * @return string|null
     */
    public function getActivityCode()
    {
        return $this->ActivityCode;
    }
    /**
     * Set ActivityCode value
     * @param string $activityCode
     * @return UserAssignmentStatus
     */
    public function setActivityCode($activityCode = null)
    {
        // validation for constraint: string
        if (!is_null($activityCode) && !is_string($activityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityCode)), __LINE__);
        }
        $this->ActivityCode = $activityCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UserAssignmentStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
