<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProficiencyValuePropertyBase StructType
 * @subpackage Structs
 */
abstract class ProficiencyValuePropertyBase extends Entity
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Value;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The ProficiencyScaleId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProficiencyScaleId;
    /**
     * The ProficiencyScale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ProficiencyScale
     */
    public $ProficiencyScale;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for ProficiencyValuePropertyBase
     * @uses ProficiencyValuePropertyBase::setValue()
     * @uses ProficiencyValuePropertyBase::setId()
     * @uses ProficiencyValuePropertyBase::setProficiencyScaleId()
     * @uses ProficiencyValuePropertyBase::setProficiencyScale()
     * @uses ProficiencyValuePropertyBase::setName()
     * @param int $value
     * @param string $id
     * @param string $proficiencyScaleId
     * @param ProficiencyScale $proficiencyScale
     * @param string $name
     */
    public function __construct($value = null, $id = null, $proficiencyScaleId = null, ProficiencyScale $proficiencyScale = null, $name = null)
    {
        $this
            ->setValue($value)
            ->setId($id)
            ->setProficiencyScaleId($proficiencyScaleId)
            ->setProficiencyScale($proficiencyScale)
            ->setName($name);
    }
    /**
     * Get Value value
     * @return int
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return ProficiencyValuePropertyBase
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ProficiencyValuePropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ProficiencyScaleId value
     * @return string|null
     */
    public function getProficiencyScaleId()
    {
        return $this->ProficiencyScaleId;
    }
    /**
     * Set ProficiencyScaleId value
     * @param string $proficiencyScaleId
     * @return ProficiencyValuePropertyBase
     */
    public function setProficiencyScaleId($proficiencyScaleId = null)
    {
        // validation for constraint: string
        if (!is_null($proficiencyScaleId) && !is_string($proficiencyScaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proficiencyScaleId)), __LINE__);
        }
        $this->ProficiencyScaleId = $proficiencyScaleId;
        return $this;
    }
    /**
     * Get ProficiencyScale value
     * @return ProficiencyScale|null
     */
    public function getProficiencyScale()
    {
        return $this->ProficiencyScale;
    }
    /**
     * Set ProficiencyScale value
     * @param ProficiencyScale $proficiencyScale
     * @return ProficiencyValuePropertyBase
     */
    public function setProficiencyScale(ProficiencyScale $proficiencyScale = null)
    {
        $this->ProficiencyScale = $proficiencyScale;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return ProficiencyValuePropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ProficiencyValuePropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
