<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationPropertyBase StructType
 * @subpackage Structs
 */
abstract class LocationPropertyBase extends Entity
{
    /**
     * The MaximumCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $MaximumCapacity;
    /**
     * The RequiresApproval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequiresApproval;
    /**
     * The OptDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate1;
    /**
     * The OptDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDateTime
     */
    public $OptDate2;
    /**
     * The OptYesNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OptYesNo;
    /**
     * The OptMoney
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $OptMoney;
    /**
     * The OptInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $OptInteger;
    /**
     * The OptFloat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDouble
     */
    public $OptFloat;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The PersonnelEMail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonnelEMail;
    /**
     * The DomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainId;
    /**
     * The Domain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Domain
     */
    public $Domain;
    /**
     * The FacilityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FacilityId;
    /**
     * The Facility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Facility
     */
    public $Facility;
    /**
     * The ApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverId;
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Approver;
    /**
     * The OptText1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText1;
    /**
     * The OptText2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText2;
    /**
     * The OptText3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText3;
    /**
     * The OptText4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptText4;
    /**
     * The OptMemo1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptMemo1;
    /**
     * The OptCurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OptCurrencyId;
    /**
     * The OptCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $OptCurrency;
    /**
     * Constructor method for LocationPropertyBase
     * @uses LocationPropertyBase::setMaximumCapacity()
     * @uses LocationPropertyBase::setRequiresApproval()
     * @uses LocationPropertyBase::setOptDate1()
     * @uses LocationPropertyBase::setOptDate2()
     * @uses LocationPropertyBase::setOptYesNo()
     * @uses LocationPropertyBase::setOptMoney()
     * @uses LocationPropertyBase::setOptInteger()
     * @uses LocationPropertyBase::setOptFloat()
     * @uses LocationPropertyBase::setId()
     * @uses LocationPropertyBase::setName()
     * @uses LocationPropertyBase::setUrl()
     * @uses LocationPropertyBase::setPersonnelEMail()
     * @uses LocationPropertyBase::setDomainId()
     * @uses LocationPropertyBase::setDomain()
     * @uses LocationPropertyBase::setFacilityId()
     * @uses LocationPropertyBase::setFacility()
     * @uses LocationPropertyBase::setApproverId()
     * @uses LocationPropertyBase::setApprover()
     * @uses LocationPropertyBase::setOptText1()
     * @uses LocationPropertyBase::setOptText2()
     * @uses LocationPropertyBase::setOptText3()
     * @uses LocationPropertyBase::setOptText4()
     * @uses LocationPropertyBase::setOptMemo1()
     * @uses LocationPropertyBase::setOptCurrencyId()
     * @uses LocationPropertyBase::setOptCurrency()
     * @param NullableInt32 $maximumCapacity
     * @param int $requiresApproval
     * @param NullableDateTime $optDate1
     * @param NullableDateTime $optDate2
     * @param bool $optYesNo
     * @param NullableDecimal $optMoney
     * @param NullableInt32 $optInteger
     * @param NullableDouble $optFloat
     * @param string $id
     * @param string $name
     * @param string $url
     * @param string $personnelEMail
     * @param string $domainId
     * @param Domain $domain
     * @param string $facilityId
     * @param Facility $facility
     * @param string $approverId
     * @param User $approver
     * @param string $optText1
     * @param string $optText2
     * @param string $optText3
     * @param string $optText4
     * @param string $optMemo1
     * @param string $optCurrencyId
     * @param Currency $optCurrency
     */
    public function __construct(NullableInt32 $maximumCapacity = null, $requiresApproval = null, NullableDateTime $optDate1 = null, NullableDateTime $optDate2 = null, $optYesNo = null, NullableDecimal $optMoney = null, NullableInt32 $optInteger = null, NullableDouble $optFloat = null, $id = null, $name = null, $url = null, $personnelEMail = null, $domainId = null, Domain $domain = null, $facilityId = null, Facility $facility = null, $approverId = null, User $approver = null, $optText1 = null, $optText2 = null, $optText3 = null, $optText4 = null, $optMemo1 = null, $optCurrencyId = null, Currency $optCurrency = null)
    {
        $this
            ->setMaximumCapacity($maximumCapacity)
            ->setRequiresApproval($requiresApproval)
            ->setOptDate1($optDate1)
            ->setOptDate2($optDate2)
            ->setOptYesNo($optYesNo)
            ->setOptMoney($optMoney)
            ->setOptInteger($optInteger)
            ->setOptFloat($optFloat)
            ->setId($id)
            ->setName($name)
            ->setUrl($url)
            ->setPersonnelEMail($personnelEMail)
            ->setDomainId($domainId)
            ->setDomain($domain)
            ->setFacilityId($facilityId)
            ->setFacility($facility)
            ->setApproverId($approverId)
            ->setApprover($approver)
            ->setOptText1($optText1)
            ->setOptText2($optText2)
            ->setOptText3($optText3)
            ->setOptText4($optText4)
            ->setOptMemo1($optMemo1)
            ->setOptCurrencyId($optCurrencyId)
            ->setOptCurrency($optCurrency);
    }
    /**
     * Get MaximumCapacity value
     * @return NullableInt32
     */
    public function getMaximumCapacity()
    {
        return $this->MaximumCapacity;
    }
    /**
     * Set MaximumCapacity value
     * @param NullableInt32 $maximumCapacity
     * @return LocationPropertyBase
     */
    public function setMaximumCapacity(NullableInt32 $maximumCapacity = null)
    {
        $this->MaximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get RequiresApproval value
     * @return int
     */
    public function getRequiresApproval()
    {
        return $this->RequiresApproval;
    }
    /**
     * Set RequiresApproval value
     * @param int $requiresApproval
     * @return LocationPropertyBase
     */
    public function setRequiresApproval($requiresApproval = null)
    {
        // validation for constraint: int
        if (!is_null($requiresApproval) && !is_numeric($requiresApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requiresApproval)), __LINE__);
        }
        $this->RequiresApproval = $requiresApproval;
        return $this;
    }
    /**
     * Get OptDate1 value
     * @return NullableDateTime
     */
    public function getOptDate1()
    {
        return $this->OptDate1;
    }
    /**
     * Set OptDate1 value
     * @param NullableDateTime $optDate1
     * @return LocationPropertyBase
     */
    public function setOptDate1(NullableDateTime $optDate1 = null)
    {
        $this->OptDate1 = $optDate1;
        return $this;
    }
    /**
     * Get OptDate2 value
     * @return NullableDateTime
     */
    public function getOptDate2()
    {
        return $this->OptDate2;
    }
    /**
     * Set OptDate2 value
     * @param NullableDateTime $optDate2
     * @return LocationPropertyBase
     */
    public function setOptDate2(NullableDateTime $optDate2 = null)
    {
        $this->OptDate2 = $optDate2;
        return $this;
    }
    /**
     * Get OptYesNo value
     * @return bool
     */
    public function getOptYesNo()
    {
        return $this->OptYesNo;
    }
    /**
     * Set OptYesNo value
     * @param bool $optYesNo
     * @return LocationPropertyBase
     */
    public function setOptYesNo($optYesNo = null)
    {
        $this->OptYesNo = $optYesNo;
        return $this;
    }
    /**
     * Get OptMoney value
     * @return NullableDecimal
     */
    public function getOptMoney()
    {
        return $this->OptMoney;
    }
    /**
     * Set OptMoney value
     * @param NullableDecimal $optMoney
     * @return LocationPropertyBase
     */
    public function setOptMoney(NullableDecimal $optMoney = null)
    {
        $this->OptMoney = $optMoney;
        return $this;
    }
    /**
     * Get OptInteger value
     * @return NullableInt32
     */
    public function getOptInteger()
    {
        return $this->OptInteger;
    }
    /**
     * Set OptInteger value
     * @param NullableInt32 $optInteger
     * @return LocationPropertyBase
     */
    public function setOptInteger(NullableInt32 $optInteger = null)
    {
        $this->OptInteger = $optInteger;
        return $this;
    }
    /**
     * Get OptFloat value
     * @return NullableDouble
     */
    public function getOptFloat()
    {
        return $this->OptFloat;
    }
    /**
     * Set OptFloat value
     * @param NullableDouble $optFloat
     * @return LocationPropertyBase
     */
    public function setOptFloat(NullableDouble $optFloat = null)
    {
        $this->OptFloat = $optFloat;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return LocationPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return LocationPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return LocationPropertyBase
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get PersonnelEMail value
     * @return string|null
     */
    public function getPersonnelEMail()
    {
        return $this->PersonnelEMail;
    }
    /**
     * Set PersonnelEMail value
     * @param string $personnelEMail
     * @return LocationPropertyBase
     */
    public function setPersonnelEMail($personnelEMail = null)
    {
        // validation for constraint: string
        if (!is_null($personnelEMail) && !is_string($personnelEMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personnelEMail)), __LINE__);
        }
        $this->PersonnelEMail = $personnelEMail;
        return $this;
    }
    /**
     * Get DomainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->DomainId;
    }
    /**
     * Set DomainId value
     * @param string $domainId
     * @return LocationPropertyBase
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->DomainId = $domainId;
        return $this;
    }
    /**
     * Get Domain value
     * @return Domain|null
     */
    public function getDomain()
    {
        return $this->Domain;
    }
    /**
     * Set Domain value
     * @param Domain $domain
     * @return LocationPropertyBase
     */
    public function setDomain(Domain $domain = null)
    {
        $this->Domain = $domain;
        return $this;
    }
    /**
     * Get FacilityId value
     * @return string|null
     */
    public function getFacilityId()
    {
        return $this->FacilityId;
    }
    /**
     * Set FacilityId value
     * @param string $facilityId
     * @return LocationPropertyBase
     */
    public function setFacilityId($facilityId = null)
    {
        // validation for constraint: string
        if (!is_null($facilityId) && !is_string($facilityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facilityId)), __LINE__);
        }
        $this->FacilityId = $facilityId;
        return $this;
    }
    /**
     * Get Facility value
     * @return Facility|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param Facility $facility
     * @return LocationPropertyBase
     */
    public function setFacility(Facility $facility = null)
    {
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Get ApproverId value
     * @return string|null
     */
    public function getApproverId()
    {
        return $this->ApproverId;
    }
    /**
     * Set ApproverId value
     * @param string $approverId
     * @return LocationPropertyBase
     */
    public function setApproverId($approverId = null)
    {
        // validation for constraint: string
        if (!is_null($approverId) && !is_string($approverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverId)), __LINE__);
        }
        $this->ApproverId = $approverId;
        return $this;
    }
    /**
     * Get Approver value
     * @return User|null
     */
    public function getApprover()
    {
        return $this->Approver;
    }
    /**
     * Set Approver value
     * @param User $approver
     * @return LocationPropertyBase
     */
    public function setApprover(User $approver = null)
    {
        $this->Approver = $approver;
        return $this;
    }
    /**
     * Get OptText1 value
     * @return string|null
     */
    public function getOptText1()
    {
        return $this->OptText1;
    }
    /**
     * Set OptText1 value
     * @param string $optText1
     * @return LocationPropertyBase
     */
    public function setOptText1($optText1 = null)
    {
        // validation for constraint: string
        if (!is_null($optText1) && !is_string($optText1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText1)), __LINE__);
        }
        $this->OptText1 = $optText1;
        return $this;
    }
    /**
     * Get OptText2 value
     * @return string|null
     */
    public function getOptText2()
    {
        return $this->OptText2;
    }
    /**
     * Set OptText2 value
     * @param string $optText2
     * @return LocationPropertyBase
     */
    public function setOptText2($optText2 = null)
    {
        // validation for constraint: string
        if (!is_null($optText2) && !is_string($optText2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText2)), __LINE__);
        }
        $this->OptText2 = $optText2;
        return $this;
    }
    /**
     * Get OptText3 value
     * @return string|null
     */
    public function getOptText3()
    {
        return $this->OptText3;
    }
    /**
     * Set OptText3 value
     * @param string $optText3
     * @return LocationPropertyBase
     */
    public function setOptText3($optText3 = null)
    {
        // validation for constraint: string
        if (!is_null($optText3) && !is_string($optText3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText3)), __LINE__);
        }
        $this->OptText3 = $optText3;
        return $this;
    }
    /**
     * Get OptText4 value
     * @return string|null
     */
    public function getOptText4()
    {
        return $this->OptText4;
    }
    /**
     * Set OptText4 value
     * @param string $optText4
     * @return LocationPropertyBase
     */
    public function setOptText4($optText4 = null)
    {
        // validation for constraint: string
        if (!is_null($optText4) && !is_string($optText4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optText4)), __LINE__);
        }
        $this->OptText4 = $optText4;
        return $this;
    }
    /**
     * Get OptMemo1 value
     * @return string|null
     */
    public function getOptMemo1()
    {
        return $this->OptMemo1;
    }
    /**
     * Set OptMemo1 value
     * @param string $optMemo1
     * @return LocationPropertyBase
     */
    public function setOptMemo1($optMemo1 = null)
    {
        // validation for constraint: string
        if (!is_null($optMemo1) && !is_string($optMemo1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optMemo1)), __LINE__);
        }
        $this->OptMemo1 = $optMemo1;
        return $this;
    }
    /**
     * Get OptCurrencyId value
     * @return string|null
     */
    public function getOptCurrencyId()
    {
        return $this->OptCurrencyId;
    }
    /**
     * Set OptCurrencyId value
     * @param string $optCurrencyId
     * @return LocationPropertyBase
     */
    public function setOptCurrencyId($optCurrencyId = null)
    {
        // validation for constraint: string
        if (!is_null($optCurrencyId) && !is_string($optCurrencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optCurrencyId)), __LINE__);
        }
        $this->OptCurrencyId = $optCurrencyId;
        return $this;
    }
    /**
     * Get OptCurrency value
     * @return Currency|null
     */
    public function getOptCurrency()
    {
        return $this->OptCurrency;
    }
    /**
     * Set OptCurrency value
     * @param Currency $optCurrency
     * @return LocationPropertyBase
     */
    public function setOptCurrency(Currency $optCurrency = null)
    {
        $this->OptCurrency = $optCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LocationPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
