<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the UserSecurityContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param UserSecurityContext $userSecurityContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUserSecurityContext(UserSecurityContext $userSecurityContext, $nameSpace = 'http://www.sumtotalsystems.com/sumtotal7/sumtotalws/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UserSecurityContext', $userSecurityContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateEmptyUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateEmptyUser $parameters
     * @return CreateEmptyUserResponse|bool
     */
    public function CreateEmptyUser(CreateEmptyUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateEmptyUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateUser
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateUser $parameters
     * @return CreateUserResponse|bool
     */
    public function CreateUser(CreateUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateUserAndUpdateJobOrg
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: UserSecurityContext
     * - SOAPHeaderNamespaces: http://www.sumtotalsystems.com/sumtotal7/sumtotalws/
     * - SOAPHeaderTypes: UserSecurityContext
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CreateUserAndUpdateJobOrg $parameters
     * @return CreateUserAndUpdateJobOrgResponse|bool
     */
    public function CreateUserAndUpdateJobOrg(CreateUserAndUpdateJobOrg $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateUserAndUpdateJobOrg($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CreateEmptyUserResponse|CreateUserAndUpdateJobOrgResponse|CreateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
