<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrganizationUser ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrganizationUser extends AbstractStructArrayBase
{
    /**
     * The OrganizationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var OrganizationUser[]
     */
    public $OrganizationUser;
    /**
     * Constructor method for ArrayOfOrganizationUser
     * @uses ArrayOfOrganizationUser::setOrganizationUser()
     * @param OrganizationUser[] $organizationUser
     */
    public function __construct(array $organizationUser = array())
    {
        $this
            ->setOrganizationUser($organizationUser);
    }
    /**
     * Get OrganizationUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return OrganizationUser[]|null
     */
    public function getOrganizationUser()
    {
        return isset($this->OrganizationUser) ? $this->OrganizationUser : null;
    }
    /**
     * Set OrganizationUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param OrganizationUser[] $organizationUser
     * @return ArrayOfOrganizationUser
     */
    public function setOrganizationUser(array $organizationUser = array())
    {
        foreach ($organizationUser as $arrayOfOrganizationUserOrganizationUserItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrganizationUserOrganizationUserItem instanceof OrganizationUser) {
                throw new \InvalidArgumentException(sprintf('The OrganizationUser property can only contain items of OrganizationUser, "%s" given', is_object($arrayOfOrganizationUserOrganizationUserItem) ? get_class($arrayOfOrganizationUserOrganizationUserItem) : gettype($arrayOfOrganizationUserOrganizationUserItem)), __LINE__);
            }
        }
        if (is_null($organizationUser) || (is_array($organizationUser) && empty($organizationUser))) {
            unset($this->OrganizationUser);
        } else {
            $this->OrganizationUser = $organizationUser;
        }
        return $this;
    }
    /**
     * Add item to OrganizationUser value
     * @throws \InvalidArgumentException
     * @param OrganizationUser $item
     * @return ArrayOfOrganizationUser
     */
    public function addToOrganizationUser(OrganizationUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrganizationUser) {
            throw new \InvalidArgumentException(sprintf('The OrganizationUser property can only contain items of OrganizationUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrganizationUser[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return OrganizationUser|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return OrganizationUser|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return OrganizationUser|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return OrganizationUser|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return OrganizationUser|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrganizationUser
     */
    public function getAttributeName()
    {
        return 'OrganizationUser';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfOrganizationUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
