<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobUser ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobUser extends AbstractStructArrayBase
{
    /**
     * The JobUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var JobUser[]
     */
    public $JobUser;
    /**
     * Constructor method for ArrayOfJobUser
     * @uses ArrayOfJobUser::setJobUser()
     * @param JobUser[] $jobUser
     */
    public function __construct(array $jobUser = array())
    {
        $this
            ->setJobUser($jobUser);
    }
    /**
     * Get JobUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return JobUser[]|null
     */
    public function getJobUser()
    {
        return isset($this->JobUser) ? $this->JobUser : null;
    }
    /**
     * Set JobUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param JobUser[] $jobUser
     * @return ArrayOfJobUser
     */
    public function setJobUser(array $jobUser = array())
    {
        foreach ($jobUser as $arrayOfJobUserJobUserItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobUserJobUserItem instanceof JobUser) {
                throw new \InvalidArgumentException(sprintf('The JobUser property can only contain items of JobUser, "%s" given', is_object($arrayOfJobUserJobUserItem) ? get_class($arrayOfJobUserJobUserItem) : gettype($arrayOfJobUserJobUserItem)), __LINE__);
            }
        }
        if (is_null($jobUser) || (is_array($jobUser) && empty($jobUser))) {
            unset($this->JobUser);
        } else {
            $this->JobUser = $jobUser;
        }
        return $this;
    }
    /**
     * Add item to JobUser value
     * @throws \InvalidArgumentException
     * @param JobUser $item
     * @return ArrayOfJobUser
     */
    public function addToJobUser(JobUser $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof JobUser) {
            throw new \InvalidArgumentException(sprintf('The JobUser property can only contain items of JobUser, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobUser[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return JobUser|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return JobUser|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return JobUser|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return JobUser|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return JobUser|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobUser
     */
    public function getAttributeName()
    {
        return 'JobUser';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfJobUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
