<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityTrack ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityTrack extends AbstractStructArrayBase
{
    /**
     * The ActivityTrack
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityTrack[]
     */
    public $ActivityTrack;
    /**
     * Constructor method for ArrayOfActivityTrack
     * @uses ArrayOfActivityTrack::setActivityTrack()
     * @param ActivityTrack[] $activityTrack
     */
    public function __construct(array $activityTrack = array())
    {
        $this
            ->setActivityTrack($activityTrack);
    }
    /**
     * Get ActivityTrack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityTrack[]|null
     */
    public function getActivityTrack()
    {
        return isset($this->ActivityTrack) ? $this->ActivityTrack : null;
    }
    /**
     * Set ActivityTrack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityTrack[] $activityTrack
     * @return ArrayOfActivityTrack
     */
    public function setActivityTrack(array $activityTrack = array())
    {
        foreach ($activityTrack as $arrayOfActivityTrackActivityTrackItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityTrackActivityTrackItem instanceof ActivityTrack) {
                throw new \InvalidArgumentException(sprintf('The ActivityTrack property can only contain items of ActivityTrack, "%s" given', is_object($arrayOfActivityTrackActivityTrackItem) ? get_class($arrayOfActivityTrackActivityTrackItem) : gettype($arrayOfActivityTrackActivityTrackItem)), __LINE__);
            }
        }
        if (is_null($activityTrack) || (is_array($activityTrack) && empty($activityTrack))) {
            unset($this->ActivityTrack);
        } else {
            $this->ActivityTrack = $activityTrack;
        }
        return $this;
    }
    /**
     * Add item to ActivityTrack value
     * @throws \InvalidArgumentException
     * @param ActivityTrack $item
     * @return ArrayOfActivityTrack
     */
    public function addToActivityTrack(ActivityTrack $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityTrack) {
            throw new \InvalidArgumentException(sprintf('The ActivityTrack property can only contain items of ActivityTrack, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityTrack[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityTrack|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityTrack|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityTrack|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityTrack|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityTrack|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityTrack
     */
    public function getAttributeName()
    {
        return 'ActivityTrack';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityTrack
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
