<?php
use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityInstructor ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityInstructor extends AbstractStructArrayBase
{
    /**
     * The ActivityInstructor
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var ActivityInstructor[]
     */
    public $ActivityInstructor;
    /**
     * Constructor method for ArrayOfActivityInstructor
     * @uses ArrayOfActivityInstructor::setActivityInstructor()
     * @param ActivityInstructor[] $activityInstructor
     */
    public function __construct(array $activityInstructor = array())
    {
        $this
            ->setActivityInstructor($activityInstructor);
    }
    /**
     * Get ActivityInstructor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ActivityInstructor[]|null
     */
    public function getActivityInstructor()
    {
        return isset($this->ActivityInstructor) ? $this->ActivityInstructor : null;
    }
    /**
     * Set ActivityInstructor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param ActivityInstructor[] $activityInstructor
     * @return ArrayOfActivityInstructor
     */
    public function setActivityInstructor(array $activityInstructor = array())
    {
        foreach ($activityInstructor as $arrayOfActivityInstructorActivityInstructorItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityInstructorActivityInstructorItem instanceof ActivityInstructor) {
                throw new \InvalidArgumentException(sprintf('The ActivityInstructor property can only contain items of ActivityInstructor, "%s" given', is_object($arrayOfActivityInstructorActivityInstructorItem) ? get_class($arrayOfActivityInstructorActivityInstructorItem) : gettype($arrayOfActivityInstructorActivityInstructorItem)), __LINE__);
            }
        }
        if (is_null($activityInstructor) || (is_array($activityInstructor) && empty($activityInstructor))) {
            unset($this->ActivityInstructor);
        } else {
            $this->ActivityInstructor = $activityInstructor;
        }
        return $this;
    }
    /**
     * Add item to ActivityInstructor value
     * @throws \InvalidArgumentException
     * @param ActivityInstructor $item
     * @return ArrayOfActivityInstructor
     */
    public function addToActivityInstructor(ActivityInstructor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ActivityInstructor) {
            throw new \InvalidArgumentException(sprintf('The ActivityInstructor property can only contain items of ActivityInstructor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityInstructor[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return ActivityInstructor|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return ActivityInstructor|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return ActivityInstructor|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return ActivityInstructor|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return ActivityInstructor|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityInstructor
     */
    public function getAttributeName()
    {
        return 'ActivityInstructor';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return ArrayOfActivityInstructor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
