<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityTrackPropertyBase StructType
 * @subpackage Structs
 */
abstract class ActivityTrackPropertyBase extends Entity
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableInt32
     */
    public $Type;
    /**
     * The CostBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $CostBase;
    /**
     * The CostWhenCancelledBeforeDeadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $CostWhenCancelledBeforeDeadline;
    /**
     * The CostWhenCancelledAfterDeadline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $CostWhenCancelledAfterDeadline;
    /**
     * The CostWhenNoShow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var NullableDecimal
     */
    public $CostWhenNoShow;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsActive;
    /**
     * The CostRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CostRule;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ApproverId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApproverId;
    /**
     * The Approver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var User
     */
    public $Approver;
    /**
     * The CurrencyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyId;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Currency
     */
    public $Currency;
    /**
     * The OwnerActivityId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerActivityId;
    /**
     * The OwnerActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Activity
     */
    public $OwnerActivity;
    /**
     * Constructor method for ActivityTrackPropertyBase
     * @uses ActivityTrackPropertyBase::setType()
     * @uses ActivityTrackPropertyBase::setCostBase()
     * @uses ActivityTrackPropertyBase::setCostWhenCancelledBeforeDeadline()
     * @uses ActivityTrackPropertyBase::setCostWhenCancelledAfterDeadline()
     * @uses ActivityTrackPropertyBase::setCostWhenNoShow()
     * @uses ActivityTrackPropertyBase::setIsActive()
     * @uses ActivityTrackPropertyBase::setCostRule()
     * @uses ActivityTrackPropertyBase::setId()
     * @uses ActivityTrackPropertyBase::setName()
     * @uses ActivityTrackPropertyBase::setDescription()
     * @uses ActivityTrackPropertyBase::setApproverId()
     * @uses ActivityTrackPropertyBase::setApprover()
     * @uses ActivityTrackPropertyBase::setCurrencyId()
     * @uses ActivityTrackPropertyBase::setCurrency()
     * @uses ActivityTrackPropertyBase::setOwnerActivityId()
     * @uses ActivityTrackPropertyBase::setOwnerActivity()
     * @param NullableInt32 $type
     * @param NullableDecimal $costBase
     * @param NullableDecimal $costWhenCancelledBeforeDeadline
     * @param NullableDecimal $costWhenCancelledAfterDeadline
     * @param NullableDecimal $costWhenNoShow
     * @param int $isActive
     * @param string $costRule
     * @param string $id
     * @param string $name
     * @param string $description
     * @param string $approverId
     * @param User $approver
     * @param string $currencyId
     * @param Currency $currency
     * @param string $ownerActivityId
     * @param Activity $ownerActivity
     */
    public function __construct(NullableInt32 $type = null, NullableDecimal $costBase = null, NullableDecimal $costWhenCancelledBeforeDeadline = null, NullableDecimal $costWhenCancelledAfterDeadline = null, NullableDecimal $costWhenNoShow = null, $isActive = null, $costRule = null, $id = null, $name = null, $description = null, $approverId = null, User $approver = null, $currencyId = null, Currency $currency = null, $ownerActivityId = null, Activity $ownerActivity = null)
    {
        $this
            ->setType($type)
            ->setCostBase($costBase)
            ->setCostWhenCancelledBeforeDeadline($costWhenCancelledBeforeDeadline)
            ->setCostWhenCancelledAfterDeadline($costWhenCancelledAfterDeadline)
            ->setCostWhenNoShow($costWhenNoShow)
            ->setIsActive($isActive)
            ->setCostRule($costRule)
            ->setId($id)
            ->setName($name)
            ->setDescription($description)
            ->setApproverId($approverId)
            ->setApprover($approver)
            ->setCurrencyId($currencyId)
            ->setCurrency($currency)
            ->setOwnerActivityId($ownerActivityId)
            ->setOwnerActivity($ownerActivity);
    }
    /**
     * Get Type value
     * @return NullableInt32
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param NullableInt32 $type
     * @return ActivityTrackPropertyBase
     */
    public function setType(NullableInt32 $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CostBase value
     * @return NullableDecimal
     */
    public function getCostBase()
    {
        return $this->CostBase;
    }
    /**
     * Set CostBase value
     * @param NullableDecimal $costBase
     * @return ActivityTrackPropertyBase
     */
    public function setCostBase(NullableDecimal $costBase = null)
    {
        $this->CostBase = $costBase;
        return $this;
    }
    /**
     * Get CostWhenCancelledBeforeDeadline value
     * @return NullableDecimal
     */
    public function getCostWhenCancelledBeforeDeadline()
    {
        return $this->CostWhenCancelledBeforeDeadline;
    }
    /**
     * Set CostWhenCancelledBeforeDeadline value
     * @param NullableDecimal $costWhenCancelledBeforeDeadline
     * @return ActivityTrackPropertyBase
     */
    public function setCostWhenCancelledBeforeDeadline(NullableDecimal $costWhenCancelledBeforeDeadline = null)
    {
        $this->CostWhenCancelledBeforeDeadline = $costWhenCancelledBeforeDeadline;
        return $this;
    }
    /**
     * Get CostWhenCancelledAfterDeadline value
     * @return NullableDecimal
     */
    public function getCostWhenCancelledAfterDeadline()
    {
        return $this->CostWhenCancelledAfterDeadline;
    }
    /**
     * Set CostWhenCancelledAfterDeadline value
     * @param NullableDecimal $costWhenCancelledAfterDeadline
     * @return ActivityTrackPropertyBase
     */
    public function setCostWhenCancelledAfterDeadline(NullableDecimal $costWhenCancelledAfterDeadline = null)
    {
        $this->CostWhenCancelledAfterDeadline = $costWhenCancelledAfterDeadline;
        return $this;
    }
    /**
     * Get CostWhenNoShow value
     * @return NullableDecimal
     */
    public function getCostWhenNoShow()
    {
        return $this->CostWhenNoShow;
    }
    /**
     * Set CostWhenNoShow value
     * @param NullableDecimal $costWhenNoShow
     * @return ActivityTrackPropertyBase
     */
    public function setCostWhenNoShow(NullableDecimal $costWhenNoShow = null)
    {
        $this->CostWhenNoShow = $costWhenNoShow;
        return $this;
    }
    /**
     * Get IsActive value
     * @return int
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param int $isActive
     * @return ActivityTrackPropertyBase
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: int
        if (!is_null($isActive) && !is_numeric($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get CostRule value
     * @return string
     */
    public function getCostRule()
    {
        return $this->CostRule;
    }
    /**
     * Set CostRule value
     * @uses TrackCostingRule::valueIsValid()
     * @uses TrackCostingRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costRule
     * @return ActivityTrackPropertyBase
     */
    public function setCostRule($costRule = null)
    {
        // validation for constraint: enumeration
        if (!TrackCostingRule::valueIsValid($costRule)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $costRule, implode(', ', TrackCostingRule::getValidValues())), __LINE__);
        }
        $this->CostRule = $costRule;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return ActivityTrackPropertyBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return ActivityTrackPropertyBase
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return ActivityTrackPropertyBase
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApproverId value
     * @return string|null
     */
    public function getApproverId()
    {
        return $this->ApproverId;
    }
    /**
     * Set ApproverId value
     * @param string $approverId
     * @return ActivityTrackPropertyBase
     */
    public function setApproverId($approverId = null)
    {
        // validation for constraint: string
        if (!is_null($approverId) && !is_string($approverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approverId)), __LINE__);
        }
        $this->ApproverId = $approverId;
        return $this;
    }
    /**
     * Get Approver value
     * @return User|null
     */
    public function getApprover()
    {
        return $this->Approver;
    }
    /**
     * Set Approver value
     * @param User $approver
     * @return ActivityTrackPropertyBase
     */
    public function setApprover(User $approver = null)
    {
        $this->Approver = $approver;
        return $this;
    }
    /**
     * Get CurrencyId value
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->CurrencyId;
    }
    /**
     * Set CurrencyId value
     * @param string $currencyId
     * @return ActivityTrackPropertyBase
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyId)), __LINE__);
        }
        $this->CurrencyId = $currencyId;
        return $this;
    }
    /**
     * Get Currency value
     * @return Currency|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param Currency $currency
     * @return ActivityTrackPropertyBase
     */
    public function setCurrency(Currency $currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get OwnerActivityId value
     * @return string|null
     */
    public function getOwnerActivityId()
    {
        return $this->OwnerActivityId;
    }
    /**
     * Set OwnerActivityId value
     * @param string $ownerActivityId
     * @return ActivityTrackPropertyBase
     */
    public function setOwnerActivityId($ownerActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerActivityId) && !is_string($ownerActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerActivityId)), __LINE__);
        }
        $this->OwnerActivityId = $ownerActivityId;
        return $this;
    }
    /**
     * Get OwnerActivity value
     * @return Activity|null
     */
    public function getOwnerActivity()
    {
        return $this->OwnerActivity;
    }
    /**
     * Set OwnerActivity value
     * @param Activity $ownerActivity
     * @return ActivityTrackPropertyBase
     */
    public function setOwnerActivity(Activity $ownerActivity = null)
    {
        $this->OwnerActivity = $ownerActivity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return ActivityTrackPropertyBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
