<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Service ServiceType
 */
$service = new \Operations\Service($options);
/**
 * Sample call for LoginUser operation/method
 */
if ($service->LoginUser(new \Parameters\LoginUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CheckUsernameForAvailability operation/method
 */
if ($service->CheckUsernameForAvailability(new \Parameters\CheckUsernameForAvailability()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for CheckSessionForExistence operation/method
 */
if ($service->CheckSessionForExistence(new \Parameters\CheckSessionForExistence()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for RegistrateUser operation/method
 */
if ($service->RegistrateUser(new \Parameters\RegistrateUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for DeactivateUser operation/method
 */
if ($service->DeactivateUser(new \Parameters\DeactivateUser()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ChangeUserData operation/method
 */
if ($service->ChangeUserData(new \Parameters\ChangeUserData()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetUserDataFromSessionId operation/method
 */
if ($service->GetUserDataFromSessionId(new \Parameters\GetUserDataFromSessionId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetSalesDataFromSessionId operation/method
 */
if ($service->GetSalesDataFromSessionId(new \Parameters\GetSalesDataFromSessionId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetAllLoginsForAddressOfThisSessionId operation/method
 */
if ($service->GetAllLoginsForAddressOfThisSessionId(new \Parameters\GetAllLoginsForAddressOfThisSessionId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for ResendPassword operation/method
 */
if ($service->ResendPassword(new \Parameters\ResendPassword()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for SetExternalSessionId operation/method
 */
if ($service->SetExternalSessionId(new \Parameters\SetExternalSessionId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for GetExternalSessionId operation/method
 */
if ($service->GetExternalSessionId(new \Parameters\GetExternalSessionId()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for NewsletterConfirmDoubleOptIn operation/method
 */
if ($service->NewsletterConfirmDoubleOptIn(new \Parameters\NewsletterConfirmDoubleOptIn()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
/**
 * Sample call for NewsletterUnsubscribe operation/method
 */
if ($service->NewsletterUnsubscribe(new \Parameters\NewsletterUnsubscribe()) !== false) {
    print_r($service->getResult());
} else {
    print_r($service->getLastError());
}
