<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetExternalSessionIdRequest Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetExternalSessionIdRequest
 * @subpackage Structs
 */
class SetExternalSessionIdRequest extends SessionRequest
{
    /**
     * The ExternalSessionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalSessionId;
    /**
     * Constructor method for SetExternalSessionIdRequest
     * @uses SetExternalSessionIdRequest::setExternalSessionId()
     * @param string $externalSessionId
     */
    public function __construct($externalSessionId = null)
    {
        $this
            ->setExternalSessionId($externalSessionId);
    }
    /**
     * Get ExternalSessionId value
     * @return string|null
     */
    public function getExternalSessionId()
    {
        return $this->ExternalSessionId;
    }
    /**
     * Set ExternalSessionId value
     * @param string $externalSessionId
     * @return \Parameters\SetExternalSessionIdRequest
     */
    public function setExternalSessionId($externalSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($externalSessionId) && !is_string($externalSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalSessionId, true), gettype($externalSessionId)), __LINE__);
        }
        $this->ExternalSessionId = $externalSessionId;
        return $this;
    }
}
