<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsletterUnsubscribeResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewsletterUnsubscribeResponse
 * @subpackage Structs
 */
class NewsletterUnsubscribeResponse extends Response
{
    /**
     * The UnsubscribeWasSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UnsubscribeWasSuccessful;
    /**
     * The NewsletterUnsubscribeResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\NewsletterUnsubscribeResponse
     */
    public $NewsletterUnsubscribeResult;
    /**
     * Constructor method for NewsletterUnsubscribeResponse
     * @uses NewsletterUnsubscribeResponse::setUnsubscribeWasSuccessful()
     * @uses NewsletterUnsubscribeResponse::setNewsletterUnsubscribeResult()
     * @param bool $unsubscribeWasSuccessful
     * @param \Parameters\NewsletterUnsubscribeResponse $newsletterUnsubscribeResult
     */
    public function __construct($unsubscribeWasSuccessful = null, \Parameters\NewsletterUnsubscribeResponse $newsletterUnsubscribeResult = null)
    {
        $this
            ->setUnsubscribeWasSuccessful($unsubscribeWasSuccessful)
            ->setNewsletterUnsubscribeResult($newsletterUnsubscribeResult);
    }
    /**
     * Get UnsubscribeWasSuccessful value
     * @return bool|null
     */
    public function getUnsubscribeWasSuccessful()
    {
        return $this->UnsubscribeWasSuccessful;
    }
    /**
     * Set UnsubscribeWasSuccessful value
     * @param bool $unsubscribeWasSuccessful
     * @return \Parameters\NewsletterUnsubscribeResponse
     */
    public function setUnsubscribeWasSuccessful($unsubscribeWasSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($unsubscribeWasSuccessful) && !is_bool($unsubscribeWasSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unsubscribeWasSuccessful, true), gettype($unsubscribeWasSuccessful)), __LINE__);
        }
        $this->UnsubscribeWasSuccessful = $unsubscribeWasSuccessful;
        return $this;
    }
    /**
     * Get NewsletterUnsubscribeResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\NewsletterUnsubscribeResponse|null
     */
    public function getNewsletterUnsubscribeResult()
    {
        return isset($this->NewsletterUnsubscribeResult) ? $this->NewsletterUnsubscribeResult : null;
    }
    /**
     * Set NewsletterUnsubscribeResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\NewsletterUnsubscribeResponse $newsletterUnsubscribeResult
     * @return \Parameters\NewsletterUnsubscribeResponse
     */
    public function setNewsletterUnsubscribeResult(\Parameters\NewsletterUnsubscribeResponse $newsletterUnsubscribeResult = null)
    {
        if (is_null($newsletterUnsubscribeResult) || (is_array($newsletterUnsubscribeResult) && empty($newsletterUnsubscribeResult))) {
            unset($this->NewsletterUnsubscribeResult);
        } else {
            $this->NewsletterUnsubscribeResult = $newsletterUnsubscribeResult;
        }
        return $this;
    }
}
