<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExternalSessionIdResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetExternalSessionIdResponse
 * @subpackage Structs
 */
class GetExternalSessionIdResponse extends Response
{
    /**
     * The ExternalSessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalSessionId;
    /**
     * The GetExternalSessionIdResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\GetExternalSessionIdResponse
     */
    public $GetExternalSessionIdResult;
    /**
     * Constructor method for GetExternalSessionIdResponse
     * @uses GetExternalSessionIdResponse::setExternalSessionId()
     * @uses GetExternalSessionIdResponse::setGetExternalSessionIdResult()
     * @param string $externalSessionId
     * @param \Parameters\GetExternalSessionIdResponse $getExternalSessionIdResult
     */
    public function __construct($externalSessionId = null, \Parameters\GetExternalSessionIdResponse $getExternalSessionIdResult = null)
    {
        $this
            ->setExternalSessionId($externalSessionId)
            ->setGetExternalSessionIdResult($getExternalSessionIdResult);
    }
    /**
     * Get ExternalSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalSessionId()
    {
        return isset($this->ExternalSessionId) ? $this->ExternalSessionId : null;
    }
    /**
     * Set ExternalSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalSessionId
     * @return \Parameters\GetExternalSessionIdResponse
     */
    public function setExternalSessionId($externalSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($externalSessionId) && !is_string($externalSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalSessionId, true), gettype($externalSessionId)), __LINE__);
        }
        if (is_null($externalSessionId) || (is_array($externalSessionId) && empty($externalSessionId))) {
            unset($this->ExternalSessionId);
        } else {
            $this->ExternalSessionId = $externalSessionId;
        }
        return $this;
    }
    /**
     * Get GetExternalSessionIdResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\GetExternalSessionIdResponse|null
     */
    public function getGetExternalSessionIdResult()
    {
        return isset($this->GetExternalSessionIdResult) ? $this->GetExternalSessionIdResult : null;
    }
    /**
     * Set GetExternalSessionIdResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\GetExternalSessionIdResponse $getExternalSessionIdResult
     * @return \Parameters\GetExternalSessionIdResponse
     */
    public function setGetExternalSessionIdResult(\Parameters\GetExternalSessionIdResponse $getExternalSessionIdResult = null)
    {
        if (is_null($getExternalSessionIdResult) || (is_array($getExternalSessionIdResult) && empty($getExternalSessionIdResult))) {
            unset($this->GetExternalSessionIdResult);
        } else {
            $this->GetExternalSessionIdResult = $getExternalSessionIdResult;
        }
        return $this;
    }
}
