<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivateUserRequest Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeactivateUserRequest
 * @subpackage Structs
 */
class DeactivateUserRequest extends Request
{
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for DeactivateUserRequest
     * @uses DeactivateUserRequest::setUsername()
     * @param string $username
     */
    public function __construct($username = null)
    {
        $this
            ->setUsername($username);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \Parameters\DeactivateUserRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
}
