<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrateUserResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RegistrateUserResponse
 * @subpackage Structs
 */
class RegistrateUserResponse extends Response
{
    /**
     * The UserRegistrationWasSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserRegistrationWasSuccessful;
    /**
     * The RegistrateUserResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\RegistrateUserResponse
     */
    public $RegistrateUserResult;
    /**
     * Constructor method for RegistrateUserResponse
     * @uses RegistrateUserResponse::setUserRegistrationWasSuccessful()
     * @uses RegistrateUserResponse::setRegistrateUserResult()
     * @param bool $userRegistrationWasSuccessful
     * @param \Parameters\RegistrateUserResponse $registrateUserResult
     */
    public function __construct($userRegistrationWasSuccessful = null, \Parameters\RegistrateUserResponse $registrateUserResult = null)
    {
        $this
            ->setUserRegistrationWasSuccessful($userRegistrationWasSuccessful)
            ->setRegistrateUserResult($registrateUserResult);
    }
    /**
     * Get UserRegistrationWasSuccessful value
     * @return bool|null
     */
    public function getUserRegistrationWasSuccessful()
    {
        return $this->UserRegistrationWasSuccessful;
    }
    /**
     * Set UserRegistrationWasSuccessful value
     * @param bool $userRegistrationWasSuccessful
     * @return \Parameters\RegistrateUserResponse
     */
    public function setUserRegistrationWasSuccessful($userRegistrationWasSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($userRegistrationWasSuccessful) && !is_bool($userRegistrationWasSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userRegistrationWasSuccessful, true), gettype($userRegistrationWasSuccessful)), __LINE__);
        }
        $this->UserRegistrationWasSuccessful = $userRegistrationWasSuccessful;
        return $this;
    }
    /**
     * Get RegistrateUserResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\RegistrateUserResponse|null
     */
    public function getRegistrateUserResult()
    {
        return isset($this->RegistrateUserResult) ? $this->RegistrateUserResult : null;
    }
    /**
     * Set RegistrateUserResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\RegistrateUserResponse $registrateUserResult
     * @return \Parameters\RegistrateUserResponse
     */
    public function setRegistrateUserResult(\Parameters\RegistrateUserResponse $registrateUserResult = null)
    {
        if (is_null($registrateUserResult) || (is_array($registrateUserResult) && empty($registrateUserResult))) {
            unset($this->RegistrateUserResult);
        } else {
            $this->RegistrateUserResult = $registrateUserResult;
        }
        return $this;
    }
}
