<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginUserResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginUserResponse
 * @subpackage Structs
 */
class LoginUserResponse extends Response
{
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SessionId;
    /**
     * The SessionTimesOutAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionTimesOutAt;
    /**
     * The LoginUserResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\LoginUserResponse
     */
    public $LoginUserResult;
    /**
     * Constructor method for LoginUserResponse
     * @uses LoginUserResponse::setSessionId()
     * @uses LoginUserResponse::setSessionTimesOutAt()
     * @uses LoginUserResponse::setLoginUserResult()
     * @param string $sessionId
     * @param string $sessionTimesOutAt
     * @param \Parameters\LoginUserResponse $loginUserResult
     */
    public function __construct($sessionId = null, $sessionTimesOutAt = null, \Parameters\LoginUserResponse $loginUserResult = null)
    {
        $this
            ->setSessionId($sessionId)
            ->setSessionTimesOutAt($sessionTimesOutAt)
            ->setLoginUserResult($loginUserResult);
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \Parameters\LoginUserResponse
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sessionId, true)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get SessionTimesOutAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionTimesOutAt()
    {
        return isset($this->SessionTimesOutAt) ? $this->SessionTimesOutAt : null;
    }
    /**
     * Set SessionTimesOutAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionTimesOutAt
     * @return \Parameters\LoginUserResponse
     */
    public function setSessionTimesOutAt($sessionTimesOutAt = null)
    {
        // validation for constraint: string
        if (!is_null($sessionTimesOutAt) && !is_string($sessionTimesOutAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionTimesOutAt, true), gettype($sessionTimesOutAt)), __LINE__);
        }
        if (is_null($sessionTimesOutAt) || (is_array($sessionTimesOutAt) && empty($sessionTimesOutAt))) {
            unset($this->SessionTimesOutAt);
        } else {
            $this->SessionTimesOutAt = $sessionTimesOutAt;
        }
        return $this;
    }
    /**
     * Get LoginUserResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\LoginUserResponse|null
     */
    public function getLoginUserResult()
    {
        return isset($this->LoginUserResult) ? $this->LoginUserResult : null;
    }
    /**
     * Set LoginUserResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\LoginUserResponse $loginUserResult
     * @return \Parameters\LoginUserResponse
     */
    public function setLoginUserResult(\Parameters\LoginUserResponse $loginUserResult = null)
    {
        if (is_null($loginUserResult) || (is_array($loginUserResult) && empty($loginUserResult))) {
            unset($this->LoginUserResult);
        } else {
            $this->LoginUserResult = $loginUserResult;
        }
        return $this;
    }
}
