<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfirmDoubleOptInRequest Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConfirmDoubleOptInRequest
 * @subpackage Structs
 */
class ConfirmDoubleOptInRequest extends Request
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The IpAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IpAddress;
    /**
     * Constructor method for ConfirmDoubleOptInRequest
     * @uses ConfirmDoubleOptInRequest::setCode()
     * @uses ConfirmDoubleOptInRequest::setIpAddress()
     * @param string $code
     * @param string $ipAddress
     */
    public function __construct($code = null, $ipAddress = null)
    {
        $this
            ->setCode($code)
            ->setIpAddress($ipAddress);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Parameters\ConfirmDoubleOptInRequest
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get IpAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->IpAddress;
    }
    /**
     * Set IpAddress value
     * @param string $ipAddress
     * @return \Parameters\ConfirmDoubleOptInRequest
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->IpAddress = $ipAddress;
        return $this;
    }
}
