<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeUserDataResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeUserDataResponse
 * @subpackage Structs
 */
class ChangeUserDataResponse extends Response
{
    /**
     * The UserDataChangedSuccessfully
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserDataChangedSuccessfully;
    /**
     * The ChangeUserDataResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\ChangeUserDataResponse
     */
    public $ChangeUserDataResult;
    /**
     * Constructor method for ChangeUserDataResponse
     * @uses ChangeUserDataResponse::setUserDataChangedSuccessfully()
     * @uses ChangeUserDataResponse::setChangeUserDataResult()
     * @param bool $userDataChangedSuccessfully
     * @param \Parameters\ChangeUserDataResponse $changeUserDataResult
     */
    public function __construct($userDataChangedSuccessfully = null, \Parameters\ChangeUserDataResponse $changeUserDataResult = null)
    {
        $this
            ->setUserDataChangedSuccessfully($userDataChangedSuccessfully)
            ->setChangeUserDataResult($changeUserDataResult);
    }
    /**
     * Get UserDataChangedSuccessfully value
     * @return bool|null
     */
    public function getUserDataChangedSuccessfully()
    {
        return $this->UserDataChangedSuccessfully;
    }
    /**
     * Set UserDataChangedSuccessfully value
     * @param bool $userDataChangedSuccessfully
     * @return \Parameters\ChangeUserDataResponse
     */
    public function setUserDataChangedSuccessfully($userDataChangedSuccessfully = null)
    {
        // validation for constraint: boolean
        if (!is_null($userDataChangedSuccessfully) && !is_bool($userDataChangedSuccessfully)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userDataChangedSuccessfully, true), gettype($userDataChangedSuccessfully)), __LINE__);
        }
        $this->UserDataChangedSuccessfully = $userDataChangedSuccessfully;
        return $this;
    }
    /**
     * Get ChangeUserDataResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\ChangeUserDataResponse|null
     */
    public function getChangeUserDataResult()
    {
        return isset($this->ChangeUserDataResult) ? $this->ChangeUserDataResult : null;
    }
    /**
     * Set ChangeUserDataResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\ChangeUserDataResponse $changeUserDataResult
     * @return \Parameters\ChangeUserDataResponse
     */
    public function setChangeUserDataResult(\Parameters\ChangeUserDataResponse $changeUserDataResult = null)
    {
        if (is_null($changeUserDataResult) || (is_array($changeUserDataResult) && empty($changeUserDataResult))) {
            unset($this->ChangeUserDataResult);
        } else {
            $this->ChangeUserDataResult = $changeUserDataResult;
        }
        return $this;
    }
}
