<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeUserDataRequest Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeUserDataRequest
 * @subpackage Structs
 */
class ChangeUserDataRequest extends SessionRequest
{
    /**
     * The UserAddressData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\UserAddressData
     */
    public $UserAddressData;
    /**
     * Constructor method for ChangeUserDataRequest
     * @uses ChangeUserDataRequest::setUserAddressData()
     * @param \Parameters\UserAddressData $userAddressData
     */
    public function __construct(\Parameters\UserAddressData $userAddressData = null)
    {
        $this
            ->setUserAddressData($userAddressData);
    }
    /**
     * Get UserAddressData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\UserAddressData|null
     */
    public function getUserAddressData()
    {
        return isset($this->UserAddressData) ? $this->UserAddressData : null;
    }
    /**
     * Set UserAddressData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\UserAddressData $userAddressData
     * @return \Parameters\ChangeUserDataRequest
     */
    public function setUserAddressData(\Parameters\UserAddressData $userAddressData = null)
    {
        if (is_null($userAddressData) || (is_array($userAddressData) && empty($userAddressData))) {
            unset($this->UserAddressData);
        } else {
            $this->UserAddressData = $userAddressData;
        }
        return $this;
    }
}
