<?php

namespace Operations;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoginUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\LoginUser $parameters
     * @return \Parameters\LoginUserResponse|bool
     */
    public function LoginUser(\Parameters\LoginUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckUsernameForAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\CheckUsernameForAvailability $parameters
     * @return \Parameters\CheckUsernameForAvailabilityResponse|bool
     */
    public function CheckUsernameForAvailability(\Parameters\CheckUsernameForAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUsernameForAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckSessionForExistence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\CheckSessionForExistence $parameters
     * @return \Parameters\CheckSessionForExistenceResponse|bool
     */
    public function CheckSessionForExistence(\Parameters\CheckSessionForExistence $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckSessionForExistence($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistrateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\RegistrateUser $parameters
     * @return \Parameters\RegistrateUserResponse|bool
     */
    public function RegistrateUser(\Parameters\RegistrateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistrateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeactivateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\DeactivateUser $parameters
     * @return \Parameters\DeactivateUserResponse|bool
     */
    public function DeactivateUser(\Parameters\DeactivateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeactivateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\ChangeUserData $parameters
     * @return \Parameters\ChangeUserDataResponse|bool
     */
    public function ChangeUserData(\Parameters\ChangeUserData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeUserData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\GetUserDataFromSessionId $parameters
     * @return \Parameters\GetUserDataFromSessionIdResponse|bool
     */
    public function GetUserDataFromSessionId(\Parameters\GetUserDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalesDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\GetSalesDataFromSessionId $parameters
     * @return \Parameters\GetSalesDataFromSessionIdResponse|bool
     */
    public function GetSalesDataFromSessionId(\Parameters\GetSalesDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalesDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllLoginsForAddressOfThisSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\GetAllLoginsForAddressOfThisSessionId $parameters
     * @return \Parameters\GetAllLoginsForAddressOfThisSessionIdResponse|bool
     */
    public function GetAllLoginsForAddressOfThisSessionId(\Parameters\GetAllLoginsForAddressOfThisSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllLoginsForAddressOfThisSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ResendPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\ResendPassword $parameters
     * @return \Parameters\ResendPasswordResponse|bool
     */
    public function ResendPassword(\Parameters\ResendPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResendPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\SetExternalSessionId $parameters
     * @return \Parameters\SetExternalSessionIdResponse|bool
     */
    public function SetExternalSessionId(\Parameters\SetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\GetExternalSessionId $parameters
     * @return \Parameters\GetExternalSessionIdResponse|bool
     */
    public function GetExternalSessionId(\Parameters\GetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NewsletterConfirmDoubleOptIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\NewsletterConfirmDoubleOptIn $parameters
     * @return \Parameters\NewsletterConfirmDoubleOptInResponse|bool
     */
    public function NewsletterConfirmDoubleOptIn(\Parameters\NewsletterConfirmDoubleOptIn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NewsletterConfirmDoubleOptIn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NewsletterUnsubscribe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Parameters\NewsletterUnsubscribe $parameters
     * @return \Parameters\NewsletterUnsubscribeResponse|bool
     */
    public function NewsletterUnsubscribe(\Parameters\NewsletterUnsubscribe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NewsletterUnsubscribe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Parameters\ChangeUserDataResponse|\Parameters\CheckSessionForExistenceResponse|\Parameters\CheckUsernameForAvailabilityResponse|\Parameters\DeactivateUserResponse|\Parameters\GetAllLoginsForAddressOfThisSessionIdResponse|\Parameters\GetExternalSessionIdResponse|\Parameters\GetSalesDataFromSessionIdResponse|\Parameters\GetUserDataFromSessionIdResponse|\Parameters\LoginUserResponse|\Parameters\NewsletterConfirmDoubleOptInResponse|\Parameters\NewsletterUnsubscribeResponse|\Parameters\RegistrateUserResponse|\Parameters\ResendPasswordResponse|\Parameters\SetExternalSessionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
