<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResendPasswordResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResendPasswordResponse
 * @subpackage Structs
 */
class ResendPasswordResponse extends Response
{
    /**
     * The ResendPasswordWasSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResendPasswordWasSuccessful;
    /**
     * The ResendPasswordResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Parameters\ResendPasswordResponse
     */
    public $ResendPasswordResult;
    /**
     * Constructor method for ResendPasswordResponse
     * @uses ResendPasswordResponse::setResendPasswordWasSuccessful()
     * @uses ResendPasswordResponse::setResendPasswordResult()
     * @param bool $resendPasswordWasSuccessful
     * @param \Parameters\ResendPasswordResponse $resendPasswordResult
     */
    public function __construct($resendPasswordWasSuccessful = null, \Parameters\ResendPasswordResponse $resendPasswordResult = null)
    {
        $this
            ->setResendPasswordWasSuccessful($resendPasswordWasSuccessful)
            ->setResendPasswordResult($resendPasswordResult);
    }
    /**
     * Get ResendPasswordWasSuccessful value
     * @return bool|null
     */
    public function getResendPasswordWasSuccessful()
    {
        return $this->ResendPasswordWasSuccessful;
    }
    /**
     * Set ResendPasswordWasSuccessful value
     * @param bool $resendPasswordWasSuccessful
     * @return \Parameters\ResendPasswordResponse
     */
    public function setResendPasswordWasSuccessful($resendPasswordWasSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($resendPasswordWasSuccessful) && !is_bool($resendPasswordWasSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resendPasswordWasSuccessful, true), gettype($resendPasswordWasSuccessful)), __LINE__);
        }
        $this->ResendPasswordWasSuccessful = $resendPasswordWasSuccessful;
        return $this;
    }
    /**
     * Get ResendPasswordResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Parameters\ResendPasswordResponse|null
     */
    public function getResendPasswordResult()
    {
        return isset($this->ResendPasswordResult) ? $this->ResendPasswordResult : null;
    }
    /**
     * Set ResendPasswordResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Parameters\ResendPasswordResponse $resendPasswordResult
     * @return \Parameters\ResendPasswordResponse
     */
    public function setResendPasswordResult(\Parameters\ResendPasswordResponse $resendPasswordResult = null)
    {
        if (is_null($resendPasswordResult) || (is_array($resendPasswordResult) && empty($resendPasswordResult))) {
            unset($this->ResendPasswordResult);
        } else {
            $this->ResendPasswordResult = $resendPasswordResult;
        }
        return $this;
    }
}
