<?php

namespace Parameters;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckSessionForExistenceRequest Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckSessionForExistenceRequest
 * @subpackage Structs
 */
class CheckSessionForExistenceRequest extends SessionRequest
{
    /**
     * The SessionTimeOutInMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SessionTimeOutInMin;
    /**
     * Constructor method for CheckSessionForExistenceRequest
     * @uses CheckSessionForExistenceRequest::setSessionTimeOutInMin()
     * @param int $sessionTimeOutInMin
     */
    public function __construct($sessionTimeOutInMin = null)
    {
        $this
            ->setSessionTimeOutInMin($sessionTimeOutInMin);
    }
    /**
     * Get SessionTimeOutInMin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSessionTimeOutInMin()
    {
        return isset($this->SessionTimeOutInMin) ? $this->SessionTimeOutInMin : null;
    }
    /**
     * Set SessionTimeOutInMin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sessionTimeOutInMin
     * @return \Parameters\CheckSessionForExistenceRequest
     */
    public function setSessionTimeOutInMin($sessionTimeOutInMin = null)
    {
        // validation for constraint: int
        if (!is_null($sessionTimeOutInMin) && !(is_int($sessionTimeOutInMin) || ctype_digit($sessionTimeOutInMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionTimeOutInMin, true), gettype($sessionTimeOutInMin)), __LINE__);
        }
        if (is_null($sessionTimeOutInMin) || (is_array($sessionTimeOutInMin) && empty($sessionTimeOutInMin))) {
            unset($this->SessionTimeOutInMin);
        } else {
            $this->SessionTimeOutInMin = $sessionTimeOutInMin;
        }
        return $this;
    }
}
