<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User Operations
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoginUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param LoginUser $parameters
     * @return LoginUserResponse|bool
     */
    public function LoginUser(LoginUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistrateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RegistrateUser $parameters
     * @return RegistrateUserResponse|bool
     */
    public function RegistrateUser(RegistrateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistrateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeactivateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param DeactivateUser $parameters
     * @return DeactivateUserResponse|bool
     */
    public function DeactivateUser(DeactivateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeactivateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return DeactivateUserResponse|LoginUserResponse|RegistrateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
