<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unsubscribe Operations
 * @subpackage Services
 */
class Unsubscribe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NewsletterUnsubscribe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param NewsletterUnsubscribe $parameters
     * @return NewsletterUnsubscribeResponse|bool
     */
    public function NewsletterUnsubscribe(NewsletterUnsubscribe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NewsletterUnsubscribe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return NewsletterUnsubscribeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
