<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Password Operations
 * @subpackage Services
 */
class Password extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResendPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ResendPassword $parameters
     * @return ResendPasswordResponse|bool
     */
    public function ResendPassword(ResendPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResendPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ResendPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
