<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Data Operations
 * @subpackage Services
 */
class Data extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangeUserData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param ChangeUserData $parameters
     * @return ChangeUserDataResponse|bool
     */
    public function ChangeUserData(ChangeUserData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeUserData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return ChangeUserDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
