<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllLoginsForAddressOfThisSessionIdResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAllLoginsForAddressOfThisSessionIdResponse
 * @subpackage Structs
 */
class GetAllLoginsForAddressOfThisSessionIdResponse extends Response
{
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AddressId;
    /**
     * The UserLogins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfUserLoginMinimalData
     */
    public $UserLogins;
    /**
     * The GetAllLoginsForAddressOfThisSessionIdResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var GetAllLoginsForAddressOfThisSessionIdResponse
     */
    public $GetAllLoginsForAddressOfThisSessionIdResult;
    /**
     * Constructor method for GetAllLoginsForAddressOfThisSessionIdResponse
     * @uses GetAllLoginsForAddressOfThisSessionIdResponse::setAddressId()
     * @uses GetAllLoginsForAddressOfThisSessionIdResponse::setUserLogins()
     * @uses GetAllLoginsForAddressOfThisSessionIdResponse::setGetAllLoginsForAddressOfThisSessionIdResult()
     * @param int $addressId
     * @param ArrayOfUserLoginMinimalData $userLogins
     * @param GetAllLoginsForAddressOfThisSessionIdResponse $getAllLoginsForAddressOfThisSessionIdResult
     */
    public function __construct($addressId = null, ArrayOfUserLoginMinimalData $userLogins = null, GetAllLoginsForAddressOfThisSessionIdResponse $getAllLoginsForAddressOfThisSessionIdResult = null)
    {
        $this
            ->setAddressId($addressId)
            ->setUserLogins($userLogins)
            ->setGetAllLoginsForAddressOfThisSessionIdResult($getAllLoginsForAddressOfThisSessionIdResult);
    }
    /**
     * Get AddressId value
     * @return int|null
     */
    public function getAddressId()
    {
        return $this->AddressId;
    }
    /**
     * Set AddressId value
     * @param int $addressId
     * @return GetAllLoginsForAddressOfThisSessionIdResponse
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        $this->AddressId = $addressId;
        return $this;
    }
    /**
     * Get UserLogins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfUserLoginMinimalData|null
     */
    public function getUserLogins()
    {
        return isset($this->UserLogins) ? $this->UserLogins : null;
    }
    /**
     * Set UserLogins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfUserLoginMinimalData $userLogins
     * @return GetAllLoginsForAddressOfThisSessionIdResponse
     */
    public function setUserLogins(ArrayOfUserLoginMinimalData $userLogins = null)
    {
        if (is_null($userLogins) || (is_array($userLogins) && empty($userLogins))) {
            unset($this->UserLogins);
        } else {
            $this->UserLogins = $userLogins;
        }
        return $this;
    }
    /**
     * Get GetAllLoginsForAddressOfThisSessionIdResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return GetAllLoginsForAddressOfThisSessionIdResponse|null
     */
    public function getGetAllLoginsForAddressOfThisSessionIdResult()
    {
        return isset($this->GetAllLoginsForAddressOfThisSessionIdResult) ? $this->GetAllLoginsForAddressOfThisSessionIdResult : null;
    }
    /**
     * Set GetAllLoginsForAddressOfThisSessionIdResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param GetAllLoginsForAddressOfThisSessionIdResponse $getAllLoginsForAddressOfThisSessionIdResult
     * @return GetAllLoginsForAddressOfThisSessionIdResponse
     */
    public function setGetAllLoginsForAddressOfThisSessionIdResult(GetAllLoginsForAddressOfThisSessionIdResponse $getAllLoginsForAddressOfThisSessionIdResult = null)
    {
        if (is_null($getAllLoginsForAddressOfThisSessionIdResult) || (is_array($getAllLoginsForAddressOfThisSessionIdResult) && empty($getAllLoginsForAddressOfThisSessionIdResult))) {
            unset($this->GetAllLoginsForAddressOfThisSessionIdResult);
        } else {
            $this->GetAllLoginsForAddressOfThisSessionIdResult = $getAllLoginsForAddressOfThisSessionIdResult;
        }
        return $this;
    }
}
