<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivateUserResponse Parameters
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeactivateUserResponse
 * @subpackage Structs
 */
class DeactivateUserResponse extends Response
{
    /**
     * The UserDeactivationWasSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserDeactivationWasSuccessful;
    /**
     * The DeactivateUserResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var DeactivateUserResponse
     */
    public $DeactivateUserResult;
    /**
     * Constructor method for DeactivateUserResponse
     * @uses DeactivateUserResponse::setUserDeactivationWasSuccessful()
     * @uses DeactivateUserResponse::setDeactivateUserResult()
     * @param bool $userDeactivationWasSuccessful
     * @param DeactivateUserResponse $deactivateUserResult
     */
    public function __construct($userDeactivationWasSuccessful = null, DeactivateUserResponse $deactivateUserResult = null)
    {
        $this
            ->setUserDeactivationWasSuccessful($userDeactivationWasSuccessful)
            ->setDeactivateUserResult($deactivateUserResult);
    }
    /**
     * Get UserDeactivationWasSuccessful value
     * @return bool|null
     */
    public function getUserDeactivationWasSuccessful()
    {
        return $this->UserDeactivationWasSuccessful;
    }
    /**
     * Set UserDeactivationWasSuccessful value
     * @param bool $userDeactivationWasSuccessful
     * @return DeactivateUserResponse
     */
    public function setUserDeactivationWasSuccessful($userDeactivationWasSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($userDeactivationWasSuccessful) && !is_bool($userDeactivationWasSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userDeactivationWasSuccessful, true), gettype($userDeactivationWasSuccessful)), __LINE__);
        }
        $this->UserDeactivationWasSuccessful = $userDeactivationWasSuccessful;
        return $this;
    }
    /**
     * Get DeactivateUserResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return DeactivateUserResponse|null
     */
    public function getDeactivateUserResult()
    {
        return isset($this->DeactivateUserResult) ? $this->DeactivateUserResult : null;
    }
    /**
     * Set DeactivateUserResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param DeactivateUserResponse $deactivateUserResult
     * @return DeactivateUserResponse
     */
    public function setDeactivateUserResult(DeactivateUserResponse $deactivateUserResult = null)
    {
        if (is_null($deactivateUserResult) || (is_array($deactivateUserResult) && empty($deactivateUserResult))) {
            unset($this->DeactivateUserResult);
        } else {
            $this->DeactivateUserResult = $deactivateUserResult;
        }
        return $this;
    }
}
