<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for User ServiceType
 */
$user = new User($options);
/**
 * Sample call for LoginUser operation/method
 */
if ($user->LoginUser(new LoginUser()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for RegistrateUser operation/method
 */
if ($user->RegistrateUser(new RegistrateUser()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for DeactivateUser operation/method
 */
if ($user->DeactivateUser(new DeactivateUser()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Availability ServiceType
 */
$availability = new Availability($options);
/**
 * Sample call for CheckUsernameForAvailability operation/method
 */
if ($availability->CheckUsernameForAvailability(new CheckUsernameForAvailability()) !== false) {
    print_r($availability->getResult());
} else {
    print_r($availability->getLastError());
}
/**
 * Samples for Existence ServiceType
 */
$existence = new Existence($options);
/**
 * Sample call for CheckSessionForExistence operation/method
 */
if ($existence->CheckSessionForExistence(new CheckSessionForExistence()) !== false) {
    print_r($existence->getResult());
} else {
    print_r($existence->getLastError());
}
/**
 * Samples for Data ServiceType
 */
$data = new Data($options);
/**
 * Sample call for ChangeUserData operation/method
 */
if ($data->ChangeUserData(new ChangeUserData()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Samples for Id ServiceType
 */
$id = new Id($options);
/**
 * Sample call for GetUserDataFromSessionId operation/method
 */
if ($id->GetUserDataFromSessionId(new GetUserDataFromSessionId()) !== false) {
    print_r($id->getResult());
} else {
    print_r($id->getLastError());
}
/**
 * Sample call for GetSalesDataFromSessionId operation/method
 */
if ($id->GetSalesDataFromSessionId(new GetSalesDataFromSessionId()) !== false) {
    print_r($id->getResult());
} else {
    print_r($id->getLastError());
}
/**
 * Sample call for GetAllLoginsForAddressOfThisSessionId operation/method
 */
if ($id->GetAllLoginsForAddressOfThisSessionId(new GetAllLoginsForAddressOfThisSessionId()) !== false) {
    print_r($id->getResult());
} else {
    print_r($id->getLastError());
}
/**
 * Sample call for SetExternalSessionId operation/method
 */
if ($id->SetExternalSessionId(new SetExternalSessionId()) !== false) {
    print_r($id->getResult());
} else {
    print_r($id->getLastError());
}
/**
 * Sample call for GetExternalSessionId operation/method
 */
if ($id->GetExternalSessionId(new GetExternalSessionId()) !== false) {
    print_r($id->getResult());
} else {
    print_r($id->getLastError());
}
/**
 * Samples for Password ServiceType
 */
$password = new Password($options);
/**
 * Sample call for ResendPassword operation/method
 */
if ($password->ResendPassword(new ResendPassword()) !== false) {
    print_r($password->getResult());
} else {
    print_r($password->getLastError());
}
/**
 * Samples for In ServiceType
 */
$in = new In($options);
/**
 * Sample call for NewsletterConfirmDoubleOptIn operation/method
 */
if ($in->NewsletterConfirmDoubleOptIn(new NewsletterConfirmDoubleOptIn()) !== false) {
    print_r($in->getResult());
} else {
    print_r($in->getLastError());
}
/**
 * Samples for Unsubscribe ServiceType
 */
$unsubscribe = new Unsubscribe($options);
/**
 * Sample call for NewsletterUnsubscribe operation/method
 */
if ($unsubscribe->NewsletterUnsubscribe(new NewsletterUnsubscribe()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
