<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Id Operations
 * @subpackage Services
 */
class Id extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetUserDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetUserDataFromSessionId $parameters
     * @return GetUserDataFromSessionIdResponse|bool
     */
    public function GetUserDataFromSessionId(GetUserDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSalesDataFromSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetSalesDataFromSessionId $parameters
     * @return GetSalesDataFromSessionIdResponse|bool
     */
    public function GetSalesDataFromSessionId(GetSalesDataFromSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSalesDataFromSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllLoginsForAddressOfThisSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetAllLoginsForAddressOfThisSessionId $parameters
     * @return GetAllLoginsForAddressOfThisSessionIdResponse|bool
     */
    public function GetAllLoginsForAddressOfThisSessionId(GetAllLoginsForAddressOfThisSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllLoginsForAddressOfThisSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SetExternalSessionId $parameters
     * @return SetExternalSessionIdResponse|bool
     */
    public function SetExternalSessionId(SetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExternalSessionId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param GetExternalSessionId $parameters
     * @return GetExternalSessionIdResponse|bool
     */
    public function GetExternalSessionId(GetExternalSessionId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExternalSessionId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return GetAllLoginsForAddressOfThisSessionIdResponse|GetExternalSessionIdResponse|GetSalesDataFromSessionIdResponse|GetUserDataFromSessionIdResponse|SetExternalSessionIdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
