<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Existence Operations
 * @subpackage Services
 */
class Existence extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckSessionForExistence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CheckSessionForExistence $parameters
     * @return CheckSessionForExistenceResponse|bool
     */
    public function CheckSessionForExistence(CheckSessionForExistence $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckSessionForExistence($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CheckSessionForExistenceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
