<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Availability Operations
 * @subpackage Services
 */
class Availability extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckUsernameForAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param CheckUsernameForAvailability $parameters
     * @return CheckUsernameForAvailabilityResponse|bool
     */
    public function CheckUsernameForAvailability(CheckUsernameForAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUsernameForAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return CheckUsernameForAvailabilityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
