<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for LoginUser operation/method
 */
if ($login->LoginUser(new \StructType\LoginUser()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckUsernameForAvailability operation/method
 */
if ($check->CheckUsernameForAvailability(new \StructType\CheckUsernameForAvailability()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckSessionForExistence operation/method
 */
if ($check->CheckSessionForExistence(new \StructType\CheckSessionForExistence()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Registrate ServiceType
 */
$registrate = new \ServiceType\Registrate($options);
/**
 * Sample call for RegistrateUser operation/method
 */
if ($registrate->RegistrateUser(new \StructType\RegistrateUser()) !== false) {
    print_r($registrate->getResult());
} else {
    print_r($registrate->getLastError());
}
/**
 * Samples for Deactivate ServiceType
 */
$deactivate = new \ServiceType\Deactivate($options);
/**
 * Sample call for DeactivateUser operation/method
 */
if ($deactivate->DeactivateUser(new \StructType\DeactivateUser()) !== false) {
    print_r($deactivate->getResult());
} else {
    print_r($deactivate->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for ChangeUserData operation/method
 */
if ($change->ChangeUserData(new \StructType\ChangeUserData()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetUserDataFromSessionId operation/method
 */
if ($get->GetUserDataFromSessionId(new \StructType\GetUserDataFromSessionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSalesDataFromSessionId operation/method
 */
if ($get->GetSalesDataFromSessionId(new \StructType\GetSalesDataFromSessionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllLoginsForAddressOfThisSessionId operation/method
 */
if ($get->GetAllLoginsForAddressOfThisSessionId(new \StructType\GetAllLoginsForAddressOfThisSessionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExternalSessionId operation/method
 */
if ($get->GetExternalSessionId(new \StructType\GetExternalSessionId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Resend ServiceType
 */
$resend = new \ServiceType\Resend($options);
/**
 * Sample call for ResendPassword operation/method
 */
if ($resend->ResendPassword(new \StructType\ResendPassword()) !== false) {
    print_r($resend->getResult());
} else {
    print_r($resend->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetExternalSessionId operation/method
 */
if ($set->SetExternalSessionId(new \StructType\SetExternalSessionId()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Newsletter ServiceType
 */
$newsletter = new \ServiceType\Newsletter($options);
/**
 * Sample call for NewsletterConfirmDoubleOptIn operation/method
 */
if ($newsletter->NewsletterConfirmDoubleOptIn(new \StructType\NewsletterConfirmDoubleOptIn()) !== false) {
    print_r($newsletter->getResult());
} else {
    print_r($newsletter->getLastError());
}
/**
 * Sample call for NewsletterUnsubscribe operation/method
 */
if ($newsletter->NewsletterUnsubscribe(new \StructType\NewsletterUnsubscribe()) !== false) {
    print_r($newsletter->getResult());
} else {
    print_r($newsletter->getLastError());
}
