<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistrateUserRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RegistrateUserRequest
 * @subpackage Structs
 */
class RegistrateUserRequest extends Request
{
    /**
     * The UserAddressData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserAddressData
     */
    public $UserAddressData;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for RegistrateUserRequest
     * @uses RegistrateUserRequest::setUserAddressData()
     * @uses RegistrateUserRequest::setUsername()
     * @param \StructType\UserAddressData $userAddressData
     * @param string $username
     */
    public function __construct(\StructType\UserAddressData $userAddressData = null, $username = null)
    {
        $this
            ->setUserAddressData($userAddressData)
            ->setUsername($username);
    }
    /**
     * Get UserAddressData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserAddressData|null
     */
    public function getUserAddressData()
    {
        return isset($this->UserAddressData) ? $this->UserAddressData : null;
    }
    /**
     * Set UserAddressData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UserAddressData $userAddressData
     * @return \StructType\RegistrateUserRequest
     */
    public function setUserAddressData(\StructType\UserAddressData $userAddressData = null)
    {
        if (is_null($userAddressData) || (is_array($userAddressData) && empty($userAddressData))) {
            unset($this->UserAddressData);
        } else {
            $this->UserAddressData = $userAddressData;
        }
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\RegistrateUserRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
}
