<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsletterUnsubscribeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NewsletterUnsubscribeRequest
 * @subpackage Structs
 */
class NewsletterUnsubscribeRequest extends Request
{
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The IpAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IpAddress;
    /**
     * Constructor method for NewsletterUnsubscribeRequest
     * @uses NewsletterUnsubscribeRequest::setEmailAddress()
     * @uses NewsletterUnsubscribeRequest::setIpAddress()
     * @param string $emailAddress
     * @param string $ipAddress
     */
    public function __construct($emailAddress = null, $ipAddress = null)
    {
        $this
            ->setEmailAddress($emailAddress)
            ->setIpAddress($ipAddress);
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\NewsletterUnsubscribeRequest
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get IpAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->IpAddress;
    }
    /**
     * Set IpAddress value
     * @param string $ipAddress
     * @return \StructType\NewsletterUnsubscribeRequest
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipAddress, true), gettype($ipAddress)), __LINE__);
        }
        $this->IpAddress = $ipAddress;
        return $this;
    }
}
