<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckUsernameForAvailabilityResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckUsernameForAvailabilityResponse
 * @subpackage Structs
 */
class CheckUsernameForAvailabilityResponse extends Response
{
    /**
     * The UsernameIsAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsernameIsAvailable;
    /**
     * The CheckUsernameForAvailabilityResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CheckUsernameForAvailabilityResponse
     */
    public $CheckUsernameForAvailabilityResult;
    /**
     * Constructor method for CheckUsernameForAvailabilityResponse
     * @uses CheckUsernameForAvailabilityResponse::setUsernameIsAvailable()
     * @uses CheckUsernameForAvailabilityResponse::setCheckUsernameForAvailabilityResult()
     * @param bool $usernameIsAvailable
     * @param \StructType\CheckUsernameForAvailabilityResponse $checkUsernameForAvailabilityResult
     */
    public function __construct($usernameIsAvailable = null, \StructType\CheckUsernameForAvailabilityResponse $checkUsernameForAvailabilityResult = null)
    {
        $this
            ->setUsernameIsAvailable($usernameIsAvailable)
            ->setCheckUsernameForAvailabilityResult($checkUsernameForAvailabilityResult);
    }
    /**
     * Get UsernameIsAvailable value
     * @return bool|null
     */
    public function getUsernameIsAvailable()
    {
        return $this->UsernameIsAvailable;
    }
    /**
     * Set UsernameIsAvailable value
     * @param bool $usernameIsAvailable
     * @return \StructType\CheckUsernameForAvailabilityResponse
     */
    public function setUsernameIsAvailable($usernameIsAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($usernameIsAvailable) && !is_bool($usernameIsAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usernameIsAvailable, true), gettype($usernameIsAvailable)), __LINE__);
        }
        $this->UsernameIsAvailable = $usernameIsAvailable;
        return $this;
    }
    /**
     * Get CheckUsernameForAvailabilityResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CheckUsernameForAvailabilityResponse|null
     */
    public function getCheckUsernameForAvailabilityResult()
    {
        return isset($this->CheckUsernameForAvailabilityResult) ? $this->CheckUsernameForAvailabilityResult : null;
    }
    /**
     * Set CheckUsernameForAvailabilityResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CheckUsernameForAvailabilityResponse $checkUsernameForAvailabilityResult
     * @return \StructType\CheckUsernameForAvailabilityResponse
     */
    public function setCheckUsernameForAvailabilityResult(\StructType\CheckUsernameForAvailabilityResponse $checkUsernameForAvailabilityResult = null)
    {
        if (is_null($checkUsernameForAvailabilityResult) || (is_array($checkUsernameForAvailabilityResult) && empty($checkUsernameForAvailabilityResult))) {
            unset($this->CheckUsernameForAvailabilityResult);
        } else {
            $this->CheckUsernameForAvailabilityResult = $checkUsernameForAvailabilityResult;
        }
        return $this;
    }
}
