<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resend ServiceType
 * @subpackage Services
 */
class Resend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResendPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResendPassword $parameters
     * @return \StructType\ResendPasswordResponse|bool
     */
    public function ResendPassword(\StructType\ResendPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResendPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResendPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
