<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckUsernameForAvailability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckUsernameForAvailability $parameters
     * @return \StructType\CheckUsernameForAvailabilityResponse|bool
     */
    public function CheckUsernameForAvailability(\StructType\CheckUsernameForAvailability $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckUsernameForAvailability($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckSessionForExistence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CheckSessionForExistence $parameters
     * @return \StructType\CheckSessionForExistenceResponse|bool
     */
    public function CheckSessionForExistence(\StructType\CheckSessionForExistence $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckSessionForExistence($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CheckSessionForExistenceResponse|\StructType\CheckUsernameForAvailabilityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
