<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Response
 * @subpackage Structs
 */
class Response extends AbstractStructBase
{
    /**
     * The ResponseErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseErrorMessage;
    /**
     * The ResponseHasNoError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResponseHasNoError;
    /**
     * Constructor method for Response
     * @uses Response::setResponseErrorMessage()
     * @uses Response::setResponseHasNoError()
     * @param string $responseErrorMessage
     * @param bool $responseHasNoError
     */
    public function __construct($responseErrorMessage = null, $responseHasNoError = null)
    {
        $this
            ->setResponseErrorMessage($responseErrorMessage)
            ->setResponseHasNoError($responseHasNoError);
    }
    /**
     * Get ResponseErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseErrorMessage()
    {
        return isset($this->ResponseErrorMessage) ? $this->ResponseErrorMessage : null;
    }
    /**
     * Set ResponseErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseErrorMessage
     * @return \StructType\Response
     */
    public function setResponseErrorMessage($responseErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseErrorMessage) && !is_string($responseErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseErrorMessage, true), gettype($responseErrorMessage)), __LINE__);
        }
        if (is_null($responseErrorMessage) || (is_array($responseErrorMessage) && empty($responseErrorMessage))) {
            unset($this->ResponseErrorMessage);
        } else {
            $this->ResponseErrorMessage = $responseErrorMessage;
        }
        return $this;
    }
    /**
     * Get ResponseHasNoError value
     * @return bool|null
     */
    public function getResponseHasNoError()
    {
        return $this->ResponseHasNoError;
    }
    /**
     * Set ResponseHasNoError value
     * @param bool $responseHasNoError
     * @return \StructType\Response
     */
    public function setResponseHasNoError($responseHasNoError = null)
    {
        // validation for constraint: boolean
        if (!is_null($responseHasNoError) && !is_bool($responseHasNoError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($responseHasNoError, true), gettype($responseHasNoError)), __LINE__);
        }
        $this->ResponseHasNoError = $responseHasNoError;
        return $this;
    }
}
