<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewsletterUnsubscribe StructType
 * @subpackage Structs
 */
class NewsletterUnsubscribe extends AbstractStructBase
{
    /**
     * The unsubscribeRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NewsletterUnsubscribeRequest
     */
    public $unsubscribeRequest;
    /**
     * Constructor method for NewsletterUnsubscribe
     * @uses NewsletterUnsubscribe::setUnsubscribeRequest()
     * @param \StructType\NewsletterUnsubscribeRequest $unsubscribeRequest
     */
    public function __construct(\StructType\NewsletterUnsubscribeRequest $unsubscribeRequest = null)
    {
        $this
            ->setUnsubscribeRequest($unsubscribeRequest);
    }
    /**
     * Get unsubscribeRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NewsletterUnsubscribeRequest|null
     */
    public function getUnsubscribeRequest()
    {
        return isset($this->unsubscribeRequest) ? $this->unsubscribeRequest : null;
    }
    /**
     * Set unsubscribeRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NewsletterUnsubscribeRequest $unsubscribeRequest
     * @return \StructType\NewsletterUnsubscribe
     */
    public function setUnsubscribeRequest(\StructType\NewsletterUnsubscribeRequest $unsubscribeRequest = null)
    {
        if (is_null($unsubscribeRequest) || (is_array($unsubscribeRequest) && empty($unsubscribeRequest))) {
            unset($this->unsubscribeRequest);
        } else {
            $this->unsubscribeRequest = $unsubscribeRequest;
        }
        return $this;
    }
}
