<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginUserRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LoginUserRequest
 * @subpackage Structs
 */
class LoginUserRequest extends Request
{
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The SessionTimeOutInMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SessionTimeOutInMin;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * Constructor method for LoginUserRequest
     * @uses LoginUserRequest::setPassword()
     * @uses LoginUserRequest::setSessionTimeOutInMin()
     * @uses LoginUserRequest::setUsername()
     * @param string $password
     * @param int $sessionTimeOutInMin
     * @param string $username
     */
    public function __construct($password = null, $sessionTimeOutInMin = null, $username = null)
    {
        $this
            ->setPassword($password)
            ->setSessionTimeOutInMin($sessionTimeOutInMin)
            ->setUsername($username);
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\LoginUserRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SessionTimeOutInMin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSessionTimeOutInMin()
    {
        return isset($this->SessionTimeOutInMin) ? $this->SessionTimeOutInMin : null;
    }
    /**
     * Set SessionTimeOutInMin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sessionTimeOutInMin
     * @return \StructType\LoginUserRequest
     */
    public function setSessionTimeOutInMin($sessionTimeOutInMin = null)
    {
        // validation for constraint: int
        if (!is_null($sessionTimeOutInMin) && !(is_int($sessionTimeOutInMin) || ctype_digit($sessionTimeOutInMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionTimeOutInMin, true), gettype($sessionTimeOutInMin)), __LINE__);
        }
        if (is_null($sessionTimeOutInMin) || (is_array($sessionTimeOutInMin) && empty($sessionTimeOutInMin))) {
            unset($this->SessionTimeOutInMin);
        } else {
            $this->SessionTimeOutInMin = $sessionTimeOutInMin;
        }
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\LoginUserRequest
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
}
